/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.indexdb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.program.indexdb.SearchableList;
import org.biojava.utils.FileAsList;

abstract class SearchableFileAsList
extends FileAsList
implements SearchableList {
    public SearchableFileAsList(File file, int recordLen) throws IOException {
        super(file, recordLen);
    }

    public SearchableFileAsList(File file, boolean mutable) throws IOException {
        super(file, mutable);
    }

    @Override
    public Object search(String id) {
        byte[] idBytes = id.getBytes();
        int min = 0;
        int max = this.size() - 1;
        do {
            int mid;
            byte[] bytes;
            int cmp;
            if ((cmp = this.cmp(bytes = this.rawGet(mid = (min + max) / 2), idBytes)) < 0) {
                if (min != mid) {
                    min = mid;
                    continue;
                }
                min = mid + 1;
                continue;
            }
            if (cmp > 0) {
                if (max != mid) {
                    max = mid;
                    continue;
                }
                max = mid - 1;
                continue;
            }
            if (cmp != 0) continue;
            return this.parseRecord(bytes);
        } while (min <= max);
        throw new NoSuchElementException("No element with ID: " + id);
    }

    @Override
    public List searchAll(String id) {
        int i;
        byte[] bytes;
        byte[] idBytes = id.getBytes();
        int min = 0;
        int max = this.size() - 1;
        int mid = -1;
        do {
            int cmp;
            if ((cmp = this.cmp(bytes = this.rawGet(mid = (min + max) / 2), idBytes)) < 0) {
                if (min != mid) {
                    min = mid;
                    continue;
                }
                min = mid + 1;
                continue;
            }
            if (cmp > 0) {
                if (max != mid) {
                    max = mid;
                    continue;
                }
                max = mid - 1;
                continue;
            }
            if (cmp == 0) break;
        } while (min <= max);
        if (min > max) {
            throw new NoSuchElementException("No element with ID: " + id);
        }
        ArrayList<Object> items = new ArrayList<Object>();
        for (i = mid - 1; i >= 0 && this.cmp(bytes = this.rawGet(i), idBytes) == 0; --i) {
            items.add(this.parseRecord(bytes));
        }
        for (i = mid; i < this.size(); ++i) {
            bytes = this.rawGet(i);
            if (this.cmp(bytes, idBytes) != 0) {
                System.out.println("Stopped at: " + i);
                break;
            }
            items.add(this.parseRecord(bytes));
        }
        return items;
    }

    private int cmp(byte[] a, byte[] b) {
        int iMax = Math.min(a.length, b.length);
        for (int i = 0; i < iMax; ++i) {
            if (a[i] < b[i]) {
                return -1;
            }
            if (a[i] <= b[i]) continue;
            return 1;
        }
        return 0;
    }
}

