/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import org.biojava.bio.program.gff.IgnoreRecordException;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.utils.ParserException;

public interface GFFErrorHandler {
    public static final GFFErrorHandler ABORT_PARSING = new AbortErrorHandler();
    public static final GFFErrorHandler SKIP_RECORD = new SkipRecordErrorHandler();

    public int invalidStart(String var1) throws ParserException, IgnoreRecordException;

    public int invalidEnd(String var1) throws ParserException, IgnoreRecordException;

    public double invalidScore(String var1) throws ParserException, IgnoreRecordException;

    public int invalidFrame(String var1) throws ParserException, IgnoreRecordException;

    public StrandedFeature.Strand invalidStrand(String var1) throws ParserException, IgnoreRecordException;

    public static class SkipRecordErrorHandler
    implements GFFErrorHandler {
        @Override
        public int invalidStart(String token) throws IgnoreRecordException {
            throw new IgnoreRecordException();
        }

        @Override
        public int invalidEnd(String token) throws IgnoreRecordException {
            throw new IgnoreRecordException();
        }

        @Override
        public double invalidScore(String token) throws IgnoreRecordException {
            throw new IgnoreRecordException();
        }

        @Override
        public int invalidFrame(String token) throws IgnoreRecordException {
            throw new IgnoreRecordException();
        }

        @Override
        public StrandedFeature.Strand invalidStrand(String token) throws IgnoreRecordException {
            throw new IgnoreRecordException();
        }
    }

    public static class AbortErrorHandler
    implements GFFErrorHandler {
        @Override
        public int invalidStart(String token) throws ParserException {
            throw new ParserException("Invalid start token");
        }

        @Override
        public int invalidEnd(String token) throws ParserException {
            throw new ParserException("Invalid end token");
        }

        @Override
        public double invalidScore(String token) throws ParserException {
            throw new ParserException("Invalid score token");
        }

        @Override
        public int invalidFrame(String token) throws ParserException {
            throw new ParserException("Invalid frame token");
        }

        @Override
        public StrandedFeature.Strand invalidStrand(String token) throws ParserException {
            throw new ParserException("Invalid strand token");
        }
    }
}

