/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.formats;

import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.EcNumber;
import org.biojava.bio.program.formats.Format;
import org.biojava.bio.program.tagvalue.ChangeTable;
import org.biojava.bio.program.tagvalue.Formats;
import org.biojava.bio.program.tagvalue.Parser;
import org.biojava.utils.ClassTools;
import org.biojava.utils.Services;
import org.biojava.utils.lsid.LifeScienceIdentifier;
import org.biojava.utils.lsid.LifeScienceIdentifierParseException;

public class FormatTools {
    private static Map LSID_2_FORMAT;
    public static final ChangeTable.Changer EC_FROM_STRING;

    private FormatTools() {
    }

    public static Format getFormat(String formatName) throws BioException {
        Format format = null;
        try {
            LifeScienceIdentifier lsid = LifeScienceIdentifier.valueOf(formatName);
            Map lsidResolvers = FormatTools.getLsid2Format();
            format = (Format)lsidResolvers.get(lsid);
        }
        catch (LifeScienceIdentifierParseException lsid) {
            // empty catch block
        }
        if (format == null) {
            String fn;
            Class<?> formatClass = null;
            try {
                formatClass = ClassTools.getClassLoader(Parser.class).loadClass(formatName);
            }
            catch (ClassNotFoundException lsidResolvers) {
                // empty catch block
            }
            if (formatClass == null) {
                fn = "org.biojava.bio.program.formats." + formatName;
                try {
                    formatClass = ClassTools.getClassLoader(Parser.class).loadClass(fn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (formatClass == null) {
                fn = "org.biojava.bio.program.formats." + formatName.replace('.', '$');
                try {
                    formatClass = ClassTools.getClassLoader(Parser.class).loadClass(fn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (formatClass != null) {
                try {
                    format = (Format)formatClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new BioException("Could not instantiate class for name " + formatName, e);
                }
                catch (IllegalAccessException e) {
                    throw new BioException("Could not instantiate class for name " + formatName, e);
                }
            }
        }
        if (format == null) {
            throw new BioException("Could not resolve format name: " + formatName);
        }
        return format;
    }

    private static Map getLsid2Format() throws BioException {
        if (LSID_2_FORMAT == null) {
            try {
                LSID_2_FORMAT = new HashMap();
                ClassLoader loader = ClassTools.getClassLoader(Formats.class);
                for (String name : Services.getImplementationNames(Format.class, loader)) {
                    Class<?> clazz = loader.loadClass(name);
                    Format format = (Format)clazz.newInstance();
                    LSID_2_FORMAT.put(format.getLSID(), format);
                }
            }
            catch (Exception e) {
                throw new BioException("Could not load service provider info for formats", e);
            }
        }
        return LSID_2_FORMAT;
    }

    static {
        EC_FROM_STRING = new ChangeTable.Changer(){

            @Override
            public Object change(Object value) {
                String sv = (String)value;
                return EcNumber.Impl.valueOf(sv);
            }
        };
    }
}

