/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import java.io.Serializable;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DPMatrix;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.State;
import org.biojava.bio.symbol.SymbolList;

public class PairDPMatrix
implements DPMatrix,
Serializable {
    private State[] states;
    private SymbolList[] seqs;
    private double[][][] scores;
    private MarkovModel model;
    private double finalScore;

    public PairDPMatrix(DP dp, SymbolList seq0, SymbolList seq1) {
        this.model = dp.getModel();
        this.states = dp.getStates();
        this.seqs = new SymbolList[2];
        this.seqs[0] = seq0;
        this.seqs[1] = seq1;
        this.finalScore = Double.NaN;
        this.scores = new double[seq0.length() + 2][seq1.length() + 2][this.states.length];
    }

    @Override
    public State[] states() {
        return this.states;
    }

    @Override
    public MarkovModel model() {
        return this.model;
    }

    @Override
    public SymbolList[] symList() {
        return this.seqs;
    }

    @Override
    public double getScore() {
        return this.finalScore;
    }

    @Override
    public double getCell(int[] indxs) {
        if (indxs.length != 3) {
            throw new IndexOutOfBoundsException("Index array must be length 3");
        }
        return this.scores[indxs[1]][indxs[2]][indxs[0]];
    }

    double[][][] getScoreArray() {
        return this.scores;
    }

    void setScore(double score) {
        this.finalScore = score;
    }
}

