/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.alignment.Alignment;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class SimpleAlignment
extends AbstractSymbolList
implements Alignment,
Serializable {
    private static final long serialVersionUID = -1760075176220928440L;
    private LinkedHashMap<String, SymbolList> labelToSymbolList;
    private List<String> labels;
    private Alphabet alphabet;
    private int length;
    private int score;

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Override
    public Symbol symbolAt(int index) {
        try {
            if (this.labels.size() == 1) {
                return this.symbolAt(this.labels.get(0), index);
            }
            return this.alphabet.getSymbol(new ColAsList<Symbol>(index));
        }
        catch (IllegalSymbolException ire) {
            throw new BioError("Somehow my crossproduct alphabet is incompatible with column " + index, ire);
        }
    }

    @Override
    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public Symbol symbolAt(String label, int column) {
        return this.symbolListForLabel(label).symbolAt(column);
    }

    @Override
    public Alignment subAlignment(Set<String> labels, Location loc) throws NoSuchElementException {
        LinkedHashMap<String, SymbolList> labelsToResList = new LinkedHashMap<String, SymbolList>();
        Iterator<String> i = labels != null ? labels.iterator() : this.getLabels().iterator();
        while (i.hasNext()) {
            String label = i.next();
            SymbolList sym = this.symbolListForLabel(label);
            if (loc != null) {
                sym = loc.symbols(sym);
            }
            labelsToResList.put(label, sym);
        }
        return new SimpleAlignment(labelsToResList);
    }

    @Override
    public SymbolList symbolListForLabel(String label) throws NoSuchElementException {
        SymbolList rl = this.labelToSymbolList.get(label);
        if (rl == null) {
            throw new NoSuchElementException("No symbol list associated with label " + label);
        }
        return rl;
    }

    public SimpleAlignment(Map<String, SymbolList> labelToResList) throws IllegalArgumentException {
        if (labelToResList.isEmpty()) {
            throw new IllegalArgumentException("Can't create an alignment with no sequences");
        }
        this.labels = Collections.unmodifiableList(new ArrayList<String>(labelToResList.keySet()));
        this.labelToSymbolList = new LinkedHashMap<String, SymbolList>(labelToResList);
        int length = -1;
        ArrayList<Alphabet> alphaList = new ArrayList<Alphabet>();
        for (String label : this.labels) {
            try {
                SymbolList rl = this.symbolListForLabel(label);
                alphaList.add(rl.getAlphabet());
                if (length == -1) {
                    length = rl.length();
                    continue;
                }
                if (rl.length() == length) continue;
                StringBuffer sb = new StringBuffer();
                for (String lab : this.labels) {
                    sb.append("\n\t" + lab + " (" + this.symbolListForLabel(lab).length() + ")");
                }
                throw new IllegalArgumentException("All SymbolLists must be the same length: " + sb.substring(0));
            }
            catch (NoSuchElementException nsee) {
                if (this.labelToSymbolList.containsKey(label)) {
                    throw new IllegalArgumentException("The symbol list associated with " + label + " is null");
                }
                throw new BioError("Something is screwey - map is lying about key/values", nsee);
            }
        }
        this.alphabet = AlphabetManager.getCrossProductAlphabet(alphaList);
        this.length = length;
    }

    @Override
    public Iterator<SymbolList> symbolListIterator() {
        return new Alignment.SymbolListIterator(this);
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    private final class ColAsList<T extends Symbol>
    extends AbstractList<T>
    implements Serializable {
        private static final long serialVersionUID = 8254702569039851040L;
        private final int col;

        public ColAsList(int col) {
            this.col = col;
        }

        @Override
        public T get(int indx) {
            return (T)SimpleAlignment.this.symbolAt((String)SimpleAlignment.this.labels.get(indx), this.col);
        }

        @Override
        public int size() {
            return SimpleAlignment.this.labels.size();
        }
    }
}

