/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeType;

public interface Alignment
extends SymbolList {
    public static final ChangeType CONTENT = new ChangeType("The sequences contained in this alignment are being changed", Alignment.class.getSimpleName(), "CONTENT");

    public List<String> getLabels();

    public Symbol symbolAt(String var1, int var2) throws NoSuchElementException;

    public SymbolList symbolListForLabel(String var1) throws NoSuchElementException;

    public Alignment subAlignment(Set<String> var1, Location var2) throws NoSuchElementException;

    public Iterator<SymbolList> symbolListIterator();

    public static class SymbolListIterator
    implements Iterator<SymbolList> {
        private final Iterator<String> labIt;
        private final Alignment ali;

        public SymbolListIterator(Alignment ali) {
            this.ali = ali;
            this.labIt = ali.getLabels().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.labIt.hasNext();
        }

        @Override
        public SymbolList next() {
            return this.ali.symbolListForLabel(this.labIt.next());
        }

        @Override
        public void remove() {
            this.labIt.remove();
        }
    }
}

