/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.LocalVariable;

public final class GeneratedCodeMethod
implements CodeMethod {
    private final String name;
    private List args;
    private List localvars;
    private LocalVariable thisV;
    private int modifiers;
    private CodeClass type;
    private CodeClass container;
    private Set thrownExceptions = new HashSet();
    private Map nameToLocals;

    GeneratedCodeMethod(CodeClass container, String name, CodeClass type, CodeClass[] args, String[] names, int modifiers) {
        this.container = container;
        this.name = name;
        this.args = new ArrayList<CodeClass>(Arrays.asList(args));
        this.modifiers = modifiers;
        this.type = type;
        this.nameToLocals = new HashMap();
        this.localvars = new ArrayList();
        for (int i = 0; i < this.args.size(); ++i) {
            if (i < names.length) {
                LocalVariable arg = new LocalVariable(args[i], names[i]);
                this.localvars.add(arg);
                this.nameToLocals.put(names[i], arg);
                continue;
            }
            this.localvars.add(new LocalVariable(args[i]));
        }
        if ((modifiers & 8) == 0) {
            this.thisV = new LocalVariable(container, "this");
            this.nameToLocals.put("this", this.thisV);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.container.getName() + "." + this.name;
    }

    @Override
    public CodeClass getContainingClass() {
        return this.container;
    }

    @Override
    public String getDescriptor() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (CodeClass cc : this.args) {
            sb.append(cc.getDescriptor());
        }
        sb.append(')');
        sb.append(this.type.getDescriptor());
        return sb.toString();
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public CodeClass getReturnType() {
        return this.type;
    }

    @Override
    public int numParameters() {
        return this.args.size();
    }

    @Override
    public CodeClass getParameterType(int pos) {
        return (CodeClass)this.args.get(pos);
    }

    public LocalVariable getVariable(int pos) {
        return (LocalVariable)this.localvars.get(pos);
    }

    public LocalVariable getVariable(String argName) throws NoSuchElementException {
        LocalVariable lv = (LocalVariable)this.nameToLocals.get(argName);
        if (lv == null) {
            throw new NoSuchElementException("Can't find local for argName " + argName);
        }
        return lv;
    }

    public LocalVariable getThis() {
        return this.thisV;
    }

    public Set getThrownExceptions() {
        return Collections.unmodifiableSet(this.thrownExceptions);
    }

    public void addThrownException(CodeClass cc) {
        this.thrownExceptions.add(cc);
    }
}

