/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util.validation;

import edu.mayo.bior.catalog.GoldenAttribute;
import edu.mayo.cli.InvalidDataException;
import edu.mayo.pipes.JSON.modify.JsonTypeExtended;

public class GoldenValidator {
    public static GoldenAttribute getGoldenAttribute(String goldenJsonKey) throws InvalidDataException {
        try {
            return GoldenAttribute.valueOf(goldenJsonKey);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isValidGolden(String inputGoldenKey) throws InvalidDataException {
        return null != GoldenValidator.getGoldenAttribute(inputGoldenKey);
    }

    public static void validateGoldenKey(String goldenJsonKey) throws InvalidDataException {
        if (null == GoldenValidator.getGoldenAttribute(goldenJsonKey)) {
            throw new InvalidDataException("Not a valid BioR golden attribute name: " + goldenJsonKey);
        }
    }

    public static void validateDataType(String goldenJsonKey, String dataType) throws InvalidDataException {
        GoldenAttribute goldenKey = GoldenValidator.getGoldenAttribute(goldenJsonKey);
        GoldenValidator.validateDataType(goldenKey, dataType);
    }

    public static void validateDataType(GoldenAttribute goldenJsonKey, String dataType) throws InvalidDataException {
        switch (goldenJsonKey) {
            case _minBP: 
            case _maxBP: {
                if (GoldenValidator.isJsonTypeNumeric(dataType)) break;
                throw new InvalidDataException(goldenJsonKey.name() + " golden attribute must be of type 'Integer'.");
            }
            case _landmark: 
            case _id: 
            case _refAllele: 
            case _altAlleles: 
            case _type: 
            case _strand: {
                if (dataType.equalsIgnoreCase("STRING")) break;
                throw new InvalidDataException(goldenJsonKey.name() + " golden attribute must be of type String.");
            }
        }
    }

    public static boolean isJsonTypeNumeric(String jsonType) {
        return JsonTypeExtended.FLOAT.toString().equalsIgnoreCase(jsonType) || JsonTypeExtended.INTEGER.toString().equalsIgnoreCase(jsonType) || "NUMBER".equalsIgnoreCase(jsonType);
    }
}

