/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.verification;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import edu.mayo.bior.catalog.CatalogFormatException;
import edu.mayo.bior.catalog.CatalogTabixEntry;
import edu.mayo.bior.catalog.verification.MessageLogger;
import htsjdk.tribble.readers.TabixReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyUtils {
    private static final Logger sLogger = LoggerFactory.getLogger(VerifyUtils.class);
    public static final String NL = System.getProperty("line.separator");
    public static final String TAB = "\t";
    private static JsonParser jp = new JsonParser();

    protected static String composeDateTime() {
        return new SimpleDateFormat("h:mm:ss a 'on' MMM d, yyyy").format(Calendar.getInstance().getTime());
    }

    protected static CatalogTabixEntry readCatalogRow(String lineInCatalog, MessageLogger logger) {
        if (lineInCatalog == null) {
            return null;
        }
        CatalogTabixEntry tabixEntry = null;
        try {
            tabixEntry = new CatalogTabixEntry(lineInCatalog);
        }
        catch (CatalogFormatException e) {
            logger.logError(e.getMessage(), 113);
        }
        return tabixEntry;
    }

    static JsonObject getJsonObject(String jsonAsString) throws JsonParseException {
        JsonObject catalogRowJsonObj = null;
        try {
            catalogRowJsonObj = jp.parse(jsonAsString).getAsJsonObject();
        }
        catch (Exception e) {
            throw new JsonParseException(String.format("Trouble parsing '%s'", jsonAsString), (Throwable)e);
        }
        return catalogRowJsonObj;
    }

    protected static Object getJsonValueForJsonKey(JsonObject jsonObj, String keyOfValueToRetrieve, String parentJsonKey) {
        Object currentJsonObj = null;
        for (Map.Entry thisEntry : jsonObj.entrySet()) {
            String strVal;
            String jsonKey = (String)thisEntry.getKey();
            if (!jsonKey.equals(keyOfValueToRetrieve) && !jsonKey.contains(keyOfValueToRetrieve)) continue;
            JsonElement jsonElem = (JsonElement)thisEntry.getValue();
            if (jsonElem.isJsonNull()) {
                System.err.println("getJavaObjectForJsonID(): Value for json key [" + jsonKey + "] is empty.");
                break;
            }
            if (jsonElem.isJsonObject()) {
                JsonObject embeddedJsonObj = jsonElem.getAsJsonObject();
                currentJsonObj = VerifyUtils.getJsonValueForJsonKey(embeddedJsonObj, keyOfValueToRetrieve, jsonKey);
                continue;
            }
            if (jsonElem.isJsonArray()) {
                JsonArray jsonArrVal = jsonElem.getAsJsonArray();
                currentJsonObj = jsonArrVal;
                break;
            }
            if (!jsonElem.isJsonPrimitive()) break;
            JsonPrimitive jsonPrimVal = jsonElem.getAsJsonPrimitive();
            if (jsonPrimVal.isBoolean()) {
                Boolean boolVal = jsonPrimVal.getAsBoolean();
                currentJsonObj = boolVal;
                break;
            }
            if (jsonPrimVal.isNumber()) {
                currentJsonObj = VerifyUtils.jsonNumberToJavaNumber(jsonPrimVal);
                break;
            }
            if (!jsonPrimVal.isString() || (strVal = jsonPrimVal.getAsString()) == null) break;
            currentJsonObj = strVal;
            break;
        }
        return currentJsonObj;
    }

    protected static boolean isTabixRetrievalSuccessful(TabixReader tabixRdr, CatalogTabixEntry tabixCatEntry, boolean firstResult) throws IOException, CatalogFormatException {
        boolean successfulMatch = false;
        boolean allResultsRelevant = true;
        TabixReader.Iterator tabixItr = VerifyUtils.getTabixIterator(tabixRdr, tabixCatEntry);
        if (tabixItr == null) {
            successfulMatch = false;
            allResultsRelevant = false;
        } else {
            int currentIteratorIdx = 0;
            int iteratorIdxThatMatched = -1;
            long numTabixResults = 0L;
            String tabixLine = null;
            while ((tabixLine = tabixItr.next()) != null) {
                ++currentIteratorIdx;
                ++numTabixResults;
                if (tabixLine.equals(tabixCatEntry.getLine())) {
                    successfulMatch = true;
                    iteratorIdxThatMatched = currentIteratorIdx;
                    continue;
                }
                CatalogTabixEntry qryResultTabixEntry = new CatalogTabixEntry(tabixLine);
                boolean tabixResultMinPosInRange = VerifyUtils.withinRange(qryResultTabixEntry.getMinPosition(), tabixCatEntry.getMinPosition(), tabixCatEntry.getMaxPosition());
                boolean tabixResultMaxPosInRange = VerifyUtils.withinRange(qryResultTabixEntry.getMaxPosition(), tabixCatEntry.getMinPosition(), tabixCatEntry.getMaxPosition());
                if (tabixResultMinPosInRange || tabixResultMaxPosInRange || qryResultTabixEntry.getMinPosition() <= tabixCatEntry.getMinPosition() && qryResultTabixEntry.getMaxPosition() >= tabixCatEntry.getMaxPosition()) continue;
                String msg = "Tabix query result catalog entry not within minBP or maxBP query range: " + NL + TAB + " queried minBP: " + tabixCatEntry.getMinPosition() + NL + TAB + " queried maxBP: " + tabixCatEntry.getMaxPosition() + NL + TAB + " result minBP out of range: " + qryResultTabixEntry.getMinPosition() + NL + TAB + " result maxBP out of range: " + qryResultTabixEntry.getMaxPosition() + NL;
                allResultsRelevant = false;
            }
            if (!(successfulMatch && firstResult && iteratorIdxThatMatched == 1 || successfulMatch && !firstResult && (long)iteratorIdxThatMatched == numTabixResults)) {
                successfulMatch = false;
            }
        }
        return successfulMatch && allResultsRelevant;
    }

    public static boolean isEmpty(String str) {
        return StringUtils.isBlank((String)str);
    }

    public static boolean isChrM(String str) {
        if (str == null) {
            return false;
        }
        String strippedStr = str.trim();
        String replacedStr = strippedStr.replaceFirst("^(?i)chr", "").toUpperCase();
        return replacedStr.equals("M") || replacedStr.equals("MT");
    }

    protected static TabixReader.Iterator getTabixIterator(TabixReader tabixRdr, CatalogTabixEntry tabixRowEntry) {
        return VerifyUtils.getTabixIterator(tabixRdr, tabixRowEntry.getChromosome(), tabixRowEntry.getMinPosition(), tabixRowEntry.getMaxPosition());
    }

    protected static TabixReader.Iterator getTabixIterator(TabixReader tabixRdr, String chr, Long start, Long stop) {
        TabixReader.Iterator chrItr;
        try {
            chrItr = tabixRdr.query(chr + ":" + start + "-" + stop);
        }
        catch (Throwable t) {
            sLogger.warn("Exception while requesting tabix iterator for region [" + chr + ":" + start + "-" + stop + "]. Exception is: " + t.getMessage());
            return null;
        }
        return chrItr;
    }

    protected static Object jsonNumberToJavaNumber(JsonPrimitive jsonNumber) {
        Number correctInstanceOfJavaNumber = null;
        Number num = VerifyUtils.stringToJavaNumber(jsonNumber.getAsString());
        if (num instanceof Long) {
            correctInstanceOfJavaNumber = (Long)num;
        } else if (num instanceof Integer) {
            correctInstanceOfJavaNumber = (Integer)num;
        } else if (num instanceof BigDecimal) {
            correctInstanceOfJavaNumber = (BigDecimal)num;
        } else if (num instanceof Double) {
            correctInstanceOfJavaNumber = (Double)num;
        }
        return correctInstanceOfJavaNumber;
    }

    protected static Number stringToJavaNumber(String value) {
        if (!value.contains(".")) {
            try {
                long longValue = Long.parseLong(value);
                if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                    return (int)longValue;
                }
                return longValue;
            }
            catch (NumberFormatException longValue) {
                // empty catch block
            }
        }
        try {
            Double valueAsADouble = Double.parseDouble(value);
            Float valueAsFloat = Float.valueOf(Float.parseFloat(value));
            if (valueAsADouble >= (double)1.4E-45f && valueAsADouble <= 3.4028234663852886E38) {
                return valueAsFloat;
            }
            return valueAsADouble;
        }
        catch (NumberFormatException nf) {
            return new BigDecimal(value);
        }
    }

    public static String trim(String inputStr) {
        if (inputStr == null) {
            return null;
        }
        return inputStr.trim();
    }

    private static boolean withinRange(long queryPosition, long minRange, long maxRange) {
        return queryPosition >= minRange && queryPosition <= maxRange;
    }
}

