/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.verification;

import edu.mayo.bior.catalog.CatalogFileUtils;
import edu.mayo.bior.catalog.HumanBuildAssembly;
import edu.mayo.bior.catalog.verification.MessageLogger;
import edu.mayo.bior.catalog.verification.VerifierInputException;
import edu.mayo.pipes.util.BiorProperties;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanReferenceInfo {
    private static Logger sLogger = LoggerFactory.getLogger(HumanReferenceInfo.class);
    private Map<String, Long> mChrSizeMap = null;
    private String mRefseqFileNm = null;
    private List<String> mExpectedChrOrderList = null;
    private String grch37ChrSizes;
    private String grch37ChrOrder;
    private String grch37RefSeq;
    private String grch38ChrSizes;
    private String grch38ChrOrder;
    private String grch38RefSeq;
    private BiorProperties biorProps;

    private void loadHumanRefAssemblyPaths() throws VerifierInputException {
        try {
            this.biorProps = new BiorProperties();
            this.grch37ChrSizes = this.biorProps.get(BiorProperties.Key.humanRefChrSizesGrch37File);
            this.grch37ChrOrder = this.biorProps.get(BiorProperties.Key.humanRefChrOrderGrch37File);
            this.grch37RefSeq = this.biorProps.get(BiorProperties.Key.humanRefSeqGrch37File);
            this.grch38ChrSizes = this.biorProps.get(BiorProperties.Key.humanRefChrSizesGrch38File);
            this.grch38ChrOrder = this.biorProps.get(BiorProperties.Key.humanRefChrOrderGrch38File);
            this.grch38RefSeq = this.biorProps.get(BiorProperties.Key.humanRefSeqGrch38File);
        }
        catch (IOException e) {
            String msg = "Could not load Human Reference Assembly paths from the bior.properties file. Msg: " + e.getMessage();
            sLogger.error(msg);
            throw new VerifierInputException(msg);
        }
    }

    public HumanReferenceInfo(HumanBuildAssembly humanRefAssembly, MessageLogger logger) throws VerifierInputException {
        this.loadHumanRefAssemblyPaths();
        if (humanRefAssembly != null) {
            if (humanRefAssembly == HumanBuildAssembly.GRCh37) {
                this.mRefseqFileNm = this.grch37RefSeq;
                this.initHumanReferenceInfo(this.grch37ChrSizes, this.grch37ChrOrder);
            } else if (humanRefAssembly == HumanBuildAssembly.GRCh38) {
                this.mRefseqFileNm = this.grch38RefSeq;
                this.initHumanReferenceInfo(this.grch38ChrSizes, this.grch38ChrOrder);
            } else {
                logger.logWarning("Can't process genome assembly [" + (Object)((Object)humanRefAssembly) + "]. Will not be verifying chromosomal positions or reference allele values.");
            }
        } else {
            logger.logWarning("Don't have genome assembly. Will not be verifying chromosomal positions or reference allele values.");
        }
    }

    public boolean canCheck() {
        return this.getChrSizeMap() != null && this.getExpectedChrOrderList() != null && this.getExpectedChrOrderList() != null;
    }

    public Map<String, Long> getChrSizeMap() {
        return this.mChrSizeMap;
    }

    public String getRefseqFileNm() {
        return this.mRefseqFileNm;
    }

    public List<String> getExpectedChrOrderList() {
        return this.mExpectedChrOrderList;
    }

    private void initHumanReferenceInfo(String chromosomeSizesFileName, String chromosomeOrderFileFileName) throws VerifierInputException {
        if (chromosomeSizesFileName == null || chromosomeSizesFileName.length() <= 0) {
            throw new VerifierInputException("Chromosome-size file specified is not valid. Cannot verify catalog positional elements without this file.");
        }
        if (chromosomeOrderFileFileName == null || chromosomeOrderFileFileName.length() <= 0) {
            throw new VerifierInputException("Chromosome-order file specified is not valid. Cannot verify catalog positional elements without this file.");
        }
        this.mChrSizeMap = this.initChrSizes(chromosomeSizesFileName);
        if (this.mChrSizeMap == null || this.mChrSizeMap.size() == 0) {
            throw new VerifierInputException("Chromosome-size map is empty. Cannot verify catalog positional elements without this info. File specified: " + chromosomeSizesFileName);
        }
        this.mExpectedChrOrderList = this.initChrOrder(chromosomeOrderFileFileName);
        if (this.mExpectedChrOrderList == null || this.mExpectedChrOrderList.size() == 0) {
            throw new VerifierInputException("Chromosome-order list is null or empty. Cannot verify catalog positional elements without this info. File specified: " + chromosomeOrderFileFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TreeMap<String, Long> initChrSizes(String genomeRefChrSizeFileNm) {
        if (genomeRefChrSizeFileNm == null) return null;
        if (genomeRefChrSizeFileNm.length() <= 0) {
            return null;
        }
        TreeMap<String, Long> map = new TreeMap<String, Long>();
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(genomeRefChrSizeFileNm));
            String n2332 = null;
            while ((n2332 = r.readLine()) != null) {
                String[] elems = n2332.trim().split("\t");
                if (elems.length != 2) {
                    r.close();
                    throw new Exception("Genome chromosome size file not in expected format. There should be only two columns in the file: " + genomeRefChrSizeFileNm);
                }
                String chr = null;
                Long iPos = null;
                try {
                    chr = elems[0].trim().replace("chr", "");
                }
                catch (Exception e) {
                    chr = null;
                }
                try {
                    iPos = new Long(elems[1].trim());
                }
                catch (Exception e) {
                    iPos = null;
                }
                if (chr == null || iPos == null) continue;
                map.put(chr, iPos);
            }
        }
        catch (Throwable t) {
            try {
                TreeMap<String, Long> treeMap = null;
                return treeMap;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        try {
            if (r == null) return map;
            r.close();
            return map;
        }
        catch (Exception n2332) {
            return map;
        }
    }

    private List<String> initChrOrder(String orderedChrFileName) throws VerifierInputException {
        ArrayList<String> orderedChrExpecting = new ArrayList<String>();
        BufferedReader r = null;
        try {
            String l;
            r = CatalogFileUtils.getBufferedReader(orderedChrFileName);
            while ((l = r.readLine()) != null) {
                String ln = l.trim();
                if (ln.length() <= 0) continue;
                String chrVal = ln;
                if (ln.startsWith("#")) continue;
                if (ln.startsWith("chr")) {
                    chrVal = ln.replace("chr", "");
                }
                orderedChrExpecting.add(chrVal);
            }
        }
        catch (IOException io) {
            throw new VerifierInputException("Unable to read and initialize chromosome order file: " + orderedChrFileName);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception exception) {}
        }
        return orderedChrExpecting;
    }
}

