/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.verification;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import edu.mayo.bior.catalog.CatalogFormatException;
import edu.mayo.bior.catalog.GoldenAttribute;
import edu.mayo.bior.catalog.verification.VerifyUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class CatalogEntryGoldenJson {
    private static final String NL = VerifyUtils.NL;
    private String landmarkChr = null;
    private Long minBP = null;
    private Long maxBP = null;
    private String refAllele = null;
    private List<String> altAlleles = null;
    private String strand = null;
    private List<String> errors = new ArrayList<String>();

    public CatalogEntryGoldenJson(String json) throws CatalogFormatException, JsonParseException {
        this(VerifyUtils.getJsonObject(json));
    }

    public CatalogEntryGoldenJson(JsonObject catalogRowJson) throws CatalogFormatException {
        this.landmarkChr = this.getStringFromJson(catalogRowJson, GoldenAttribute._landmark.toString());
        this.minBP = this.getLongFromJson(catalogRowJson, GoldenAttribute._minBP.toString());
        this.maxBP = this.getLongFromJson(catalogRowJson, GoldenAttribute._maxBP.toString());
        this.refAllele = this.getStringFromJson(catalogRowJson, GoldenAttribute._refAllele.toString());
        this.strand = this.getStringFromJson(catalogRowJson, GoldenAttribute._strand.toString());
        this.altAlleles = this.getStringArrayFromJson(catalogRowJson, GoldenAttribute._altAlleles.toString());
        if (this.errors.size() > 0) {
            throw new CatalogFormatException(StringUtils.join(this.errors, (String)NL));
        }
    }

    public boolean isVariant() {
        return this.getRefAllele() != null;
    }

    private String getStringFromJson(JsonObject catalogRowJson, String key) {
        if (catalogRowJson.get(key) == null) {
            return null;
        }
        JsonPrimitive jsonPrimitiveString = catalogRowJson.getAsJsonPrimitive(key);
        if (jsonPrimitiveString == null) {
            this.errors.add(String.format("Couldn't get key '%s' from json '%s' as a JsonPrimitive. It should be a string", key, catalogRowJson.toString()));
            return null;
        }
        if (!jsonPrimitiveString.isString()) {
            this.errors.add(String.format("key %s value '%s' from json '%s' is not a JSON string: ", key, jsonPrimitiveString.getAsString(), catalogRowJson.toString()));
        }
        return jsonPrimitiveString.getAsString();
    }

    private Long getLongFromJson(JsonObject catalogRowJson, String key) {
        if (catalogRowJson.get(key) == null) {
            return null;
        }
        JsonPrimitive jsonPrimitiveInt = catalogRowJson.getAsJsonPrimitive(key);
        if (jsonPrimitiveInt == null) {
            this.errors.add(String.format("Couldn't get key '%s' from json '%s' as a JsonPrimitive. It should be an integer", key, catalogRowJson.toString()));
            return null;
        }
        if (!jsonPrimitiveInt.isNumber()) {
            this.errors.add(String.format("key %s value '%s' from json '%s' is not a JSON number: ", key, jsonPrimitiveInt.getAsString(), catalogRowJson.toString()));
            return null;
        }
        try {
            return new Long(jsonPrimitiveInt.getAsString());
        }
        catch (NumberFormatException e) {
            this.errors.add(String.format("key %s value '%s' from json '%s' is not an integer: ", key, jsonPrimitiveInt.getAsString(), catalogRowJson.toString()));
            return null;
        }
    }

    private List<String> getStringArrayFromJson(JsonObject catalogRowJson, String key) {
        JsonArray jsonArray;
        if (catalogRowJson.get(key) == null) {
            return null;
        }
        try {
            jsonArray = catalogRowJson.getAsJsonArray(key);
            if (jsonArray == null) {
                this.errors.add(String.format("Couldn't get key '%s' from json '%s' as a JSON Array.", key, catalogRowJson.toString()));
                return null;
            }
        }
        catch (Exception e) {
            this.errors.add(String.format("Couldn't get key '%s' from json '%s' as a JSON Array.", key, catalogRowJson.toString()));
            return null;
        }
        Iterator iterator = jsonArray.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (iterator.hasNext()) {
            JsonElement jsonElement = (JsonElement)iterator.next();
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive == null) {
                this.errors.add(String.format("Couldn't get an item from array for '%s' from json '%s' as a JsonPrimitive. It should be a string", key, catalogRowJson.toString()));
                return null;
            }
            if (!jsonPrimitive.isString()) {
                this.errors.add(String.format("Item from array for key %s value '%s' from json '%s' is not a JSON string: ", key, jsonPrimitive.getAsString(), catalogRowJson.toString()));
                return null;
            }
            list.add(jsonPrimitive.getAsString());
        }
        return list;
    }

    public String getChr() {
        return this.landmarkChr;
    }

    public Long getMinBP() {
        return this.minBP;
    }

    public Long getMaxBP() {
        return this.maxBP;
    }

    public String getRefAllele() {
        return this.refAllele;
    }

    public List<String> getAltAlleles() {
        return this.altAlleles;
    }

    public String getStrand() {
        return this.strand;
    }

    public boolean equals(CatalogEntryGoldenJson otherVariant) {
        if (ObjectUtils.notEqual((Object)this.getChr(), (Object)otherVariant.getChr())) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)this.getMinBP(), (Object)otherVariant.getMinBP())) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)this.getMaxBP(), (Object)otherVariant.getMaxBP())) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)this.getRefAllele(), (Object)otherVariant.getRefAllele())) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)this.getStrand(), (Object)otherVariant.getStrand())) {
            return false;
        }
        List<String> theseAlts = this.getAltAlleles();
        List<String> otherAlts = otherVariant.getAltAlleles();
        if (theseAlts == null && otherAlts != null) {
            return false;
        }
        if (theseAlts != null && otherAlts == null) {
            return false;
        }
        if (theseAlts != null) {
            if (theseAlts.size() != otherAlts.size()) {
                return false;
            }
            for (String eachAlt : theseAlts) {
                if (otherAlts.contains(eachAlt)) continue;
                return false;
            }
        }
        return true;
    }
}

