/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.sage;

import edu.mayo.sage.JsonUsageLoggerBase;
import edu.mayo.sage.TcpLogger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UdpLogger
extends JsonUsageLoggerBase {
    private static final Logger logger = LoggerFactory.getLogger(TcpLogger.class);
    private String serverHost;
    private int serverPort;
    private String clientHost;
    private int clientPort;
    private boolean failOnError;

    UdpLogger(String serverHost, int serverPort, String clientHost, int clientPort, boolean failOnError) {
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.clientHost = clientHost;
        this.clientPort = clientPort;
        this.failOnError = failOnError;
    }

    @Override
    public void sendData(byte[] data, int offset, int length) {
        block2: {
            try {
                DatagramSocket socket = new DatagramSocket(new InetSocketAddress(this.clientHost, this.clientPort));
                DatagramPacket packet = new DatagramPacket(data, offset, length, new InetSocketAddress(this.serverHost, this.serverPort));
                socket.send(packet);
                socket.close();
            }
            catch (Exception e) {
                logger.error("Problem logging usage. Details: " + e.getMessage());
                if (!this.failOnError) break block2;
                throw new RuntimeException("The logger could not send usage information to " + this.serverHost + ":" + this.serverPort, e);
            }
        }
    }
}

