/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.sage;

import edu.mayo.sage.JsonUsageLoggerBase;
import java.net.InetAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TcpLogger
extends JsonUsageLoggerBase {
    private static final Logger logger = LoggerFactory.getLogger(TcpLogger.class);
    private static final int SOCKET_TIMEOUT = 1000;
    private String serverHost;
    private int serverPort;
    private String clientHost;
    private int clientPort;
    private boolean failOnError;

    TcpLogger(String serverHost, int serverPort, String clientHost, int clientPort, boolean failOnError) {
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.clientHost = clientHost;
        this.clientPort = clientPort;
        this.failOnError = failOnError;
    }

    @Override
    public void sendData(byte[] data, int offset, int length) {
        block2: {
            try {
                Socket socket = new Socket(this.serverHost, this.serverPort, InetAddress.getByName(this.clientHost), this.clientPort);
                socket.setSoTimeout(1000);
                socket.getOutputStream().write(data, offset, length);
                socket.close();
            }
            catch (Exception e) {
                logger.error("Problem logging usage. Details: " + e.getMessage());
                if (!this.failOnError) break block2;
                throw new RuntimeException("The logger could not send usage information to " + this.serverHost + ":" + this.serverPort, e);
            }
        }
    }
}

