/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.sage;

import edu.mayo.sage.JsonUsageLoggerBase;
import edu.mayo.sage.UsageLoggerUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.UnexpectedException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SplunkHttpsLogger
extends JsonUsageLoggerBase {
    private static final Logger logger = LoggerFactory.getLogger(SplunkHttpsLogger.class);
    private static final int SOCKET_TIMEOUT = 1000;
    private String serverUrl;
    private String indexName;
    private String splunkToken;
    private String source;
    private boolean failOnError;

    public SplunkHttpsLogger(String serverUrl, String indexName, String source, String splunkToken, boolean failOnError) {
        this.serverUrl = serverUrl;
        this.indexName = indexName;
        this.splunkToken = splunkToken;
        this.source = source;
        this.failOnError = failOnError;
    }

    @Override
    void logEvent(Map<String, Object> data) {
        HashMap<String, Object> wrapper = new HashMap<String, Object>();
        wrapper.put("event", data);
        wrapper.put("sourcetype", "_json");
        wrapper.put("source", this.source);
        wrapper.put("index", this.indexName);
        byte[] buffer = UsageLoggerUtils.mapToJsonByteArray(wrapper);
        logger.debug(String.format("Logging event - message has length %d", buffer.length));
        this.sendData(buffer, 0, buffer.length);
    }

    @Override
    public void sendData(byte[] data, int offset, int length) {
        block5: {
            try {
                URL url = new URL(this.serverUrl);
                HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
                con.setConnectTimeout(1000);
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-Type", "application/json; utf-8");
                con.setRequestProperty("Accept", "application/json");
                con.setRequestProperty("Authorization", "Splunk " + this.splunkToken);
                con.setDoOutput(true);
                OutputStream out = con.getOutputStream();
                out.write(data, offset, length);
                out.flush();
                out.close();
                int status = con.getResponseCode();
                if (status != 200) {
                    BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "utf-8"));
                    StringBuilder response = new StringBuilder();
                    String responseLine = null;
                    while ((responseLine = br.readLine()) != null) {
                        response.append(responseLine.trim());
                    }
                    logger.warn(String.format("Unexpected response from splunk: %s", response));
                    if (this.failOnError) {
                        throw new UnexpectedException(String.format("Unexpected response from splunk %s", response));
                    }
                }
            }
            catch (Exception e) {
                logger.error("Problem logging event. Details: " + e.getMessage());
                if (!this.failOnError) break block5;
                throw new RuntimeException("The logger could not send event information to server " + this.serverUrl + " index" + this.indexName, e);
            }
        }
    }
}

