/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.sage;

import edu.mayo.sage.UsageLogger;
import edu.mayo.sage.UsageLoggerUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class JsonUsageLoggerBase
implements UsageLogger {
    private static final Logger logger = LoggerFactory.getLogger(JsonUsageLoggerBase.class);

    JsonUsageLoggerBase() {
    }

    void logEvent(Map<String, Object> data) {
        byte[] buffer = UsageLoggerUtils.mapToJsonByteArray(data);
        logger.debug(String.format("Logging event - message has length %d", buffer.length));
        this.sendData(buffer, 0, buffer.length);
    }

    void logEvent(Object ... data) {
        this.logEvent(UsageLoggerUtils.arrayToMap(data));
    }

    @Override
    public void logBegin(String appName) {
        logger.info("Logging begin event");
        this.logEvent(appName, "EVENT_BEGIN");
    }

    @Override
    public void logBegin(String appName, Map<String, Object> data) {
        logger.info("Logging begin event");
        this.logEvent(appName, "EVENT_BEGIN", data);
    }

    @Override
    public void logBegin(String appName, Object ... data) {
        logger.info("Logging begin event");
        this.logEvent(appName, "EVENT_BEGIN", data);
    }

    @Override
    public void logEnd(String appName) {
        logger.info("Logging end event");
        this.logEvent(appName, "EVENT_END");
    }

    @Override
    public void logEnd(String appName, Map<String, Object> data) {
        logger.info("Logging end event");
        this.logEvent(appName, "EVENT_END", data);
    }

    @Override
    public void logEnd(String appName, Object ... data) {
        logger.info("Logging end event");
        this.logEvent(appName, "EVENT_END", data);
    }

    @Override
    public void logEvent(String appName, String event) {
        Map<String, Object> m = this.getDefaultAttributes(appName, event);
        this.logEvent(m);
    }

    @Override
    public void logEvent(String appName, String event, Map<String, Object> data) {
        Map<String, Object> m = this.getDefaultAttributes(appName, event);
        m.putAll(data);
        this.logEvent(m);
    }

    @Override
    public void logEvent(String appName, String event, Object ... data) {
        Map<String, Object> m = this.getDefaultAttributes(appName, event);
        m.putAll(UsageLoggerUtils.arrayToMap(data));
        this.logEvent(m);
    }

    @Override
    public void logError(String appName, Throwable t, int exitStatus) {
        Map<String, Object> m = this.getDefaultAttributes(appName, "ERROR");
        m.put("error", t.getMessage());
        m.put("exit_status", exitStatus);
        this.logEvent(m);
    }

    private Map<String, Object> getDefaultAttributes(String appName, String event) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("app", appName);
        m.put("evt", event);
        m.put("user", UsageLoggerUtils.getUsername());
        m.put("mem", UsageLoggerUtils.getHeapSize());
        m.put("pid", UsageLoggerUtils.getProcessID());
        return m;
    }

    public abstract void sendData(byte[] var1, int var2, int var3);
}

