/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class Pool<T> {
    private final Queue<T> freeObjects;
    private int peak;

    public Pool(boolean threadSafe, boolean softReferences) {
        this(threadSafe, softReferences, Integer.MAX_VALUE);
    }

    public Pool(boolean threadSafe, boolean softReferences, final int maximumCapacity) {
        AbstractCollection queue = threadSafe ? new LinkedBlockingQueue(maximumCapacity) : (softReferences ? new LinkedList(){

            @Override
            public boolean add(Object object) {
                if (this.size() >= maximumCapacity) {
                    return false;
                }
                super.add(object);
                return true;
            }
        } : new ArrayDeque(){

            @Override
            public boolean add(Object object) {
                if (this.size() >= maximumCapacity) {
                    return false;
                }
                super.add(object);
                return true;
            }
        });
        this.freeObjects = softReferences ? new SoftReferenceQueue((Queue)((Object)queue)) : queue;
    }

    protected abstract T create();

    public T obtain() {
        T object = this.freeObjects.poll();
        return object != null ? object : this.create();
    }

    public void free(T object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        if (!this.freeObjects.add(object) && this.freeObjects instanceof SoftReferenceQueue) {
            ((SoftReferenceQueue)this.freeObjects).cleanOne();
            this.freeObjects.add(object);
        }
        this.peak = Math.max(this.peak, this.freeObjects.size());
        this.reset(object);
    }

    protected void reset(T object) {
        if (object instanceof Poolable) {
            ((Poolable)object).reset();
        }
    }

    public void clear() {
        this.freeObjects.clear();
    }

    public void clean() {
        if (this.freeObjects instanceof SoftReferenceQueue) {
            ((SoftReferenceQueue)this.freeObjects).clean();
        }
    }

    public int getFree() {
        return this.freeObjects.size();
    }

    public int getPeak() {
        return this.peak;
    }

    public void resetPeak() {
        this.peak = 0;
    }

    static class SoftReferenceQueue<T>
    implements Queue<T> {
        private Queue delegate;

        public SoftReferenceQueue(Queue delegate) {
            this.delegate = delegate;
        }

        @Override
        public T poll() {
            SoftReference reference;
            Object object;
            do {
                if ((reference = (SoftReference)this.delegate.poll()) != null) continue;
                return null;
            } while ((object = reference.get()) == null);
            return object;
        }

        @Override
        public boolean add(T e) {
            return this.delegate.add(new SoftReference<T>(e));
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        void cleanOne() {
            Iterator iter = this.delegate.iterator();
            while (iter.hasNext()) {
                if (((SoftReference)iter.next()).get() != null) continue;
                iter.remove();
                break;
            }
        }

        void clean() {
            Iterator iter = this.delegate.iterator();
            while (iter.hasNext()) {
                if (((SoftReference)iter.next()).get() != null) continue;
                iter.remove();
            }
        }

        @Override
        public boolean offer(T e) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return null;
        }

        @Override
        public T remove() {
            return null;
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public T element() {
            return null;
        }

        @Override
        public T peek() {
            return null;
        }

        @Override
        public <E> E[] toArray(E[] a) {
            return null;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection c) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection c) {
            return false;
        }
    }

    public static interface Poolable {
        public void reset();
    }
}

