/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.exec;

import edu.mayo.exec.BaseCommand;
import edu.mayo.exec.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Command
extends BaseCommand {
    private static final Logger sLogger = LoggerFactory.getLogger(Command.class);
    private String mStdout = null;
    private String mStderr = null;
    private Integer mExit = null;
    private PrintWriter mStdoutPushWriter;
    private PrintWriter mStderrPushWriter;

    public Command(String[] cmdarray, Map<String, String> customEnv, boolean useParentEnv) {
        super(cmdarray, customEnv, useParentEnv);
    }

    public Command(String[] cmdarray, Map<String, String> customEnv, boolean useParentEnv, File workingDirectory) {
        super(cmdarray, customEnv, useParentEnv, workingDirectory);
    }

    public Command(String[] cmdarray, Map<String, String> customEnv, boolean useParentEnv, File workingDirectory, PrintWriter stdout, PrintWriter stderr) {
        super(cmdarray, customEnv, useParentEnv, workingDirectory);
        this.mStdoutPushWriter = stdout;
        this.mStderrPushWriter = stderr;
    }

    public void execute() throws IOException, InterruptedException {
        this.execute(Collections.emptyList());
    }

    public void execute(List<String> inputLines) throws IOException, InterruptedException {
        Process p = this.launchProcess();
        StreamGobbler stdoutGobbler = this.mStdoutPushWriter != null ? new StreamGobbler(p.getInputStream(), this.mStdoutPushWriter) : new StreamGobbler(p.getInputStream());
        Thread stdoutThread = new Thread((Runnable)stdoutGobbler, "STDOUT");
        stdoutThread.start();
        sLogger.debug(String.format("Started %s gobbler", stdoutThread.getName()));
        StreamGobbler stderrGobbler = this.mStderrPushWriter != null ? new StreamGobbler(p.getErrorStream(), this.mStderrPushWriter) : new StreamGobbler(p.getErrorStream());
        Thread stderrThread = new Thread((Runnable)stderrGobbler, "STDERR");
        stderrThread.start();
        sLogger.debug(String.format("Started %s gobbler", stderrThread.getName()));
        PrintWriter stdinWriter = new PrintWriter(new OutputStreamWriter(p.getOutputStream()));
        for (String line : inputLines) {
            stdinWriter.println(line);
            if (!sLogger.isDebugEnabled()) continue;
            sLogger.debug(String.format("Sent line to STDIN: %s", line));
        }
        stdinWriter.flush();
        stdinWriter.close();
        sLogger.debug("Sent signal end-of-transmission to STDIN");
        int exit = p.waitFor();
        sLogger.debug(String.format("Process exited with exit code %s", exit));
        this.mExit = exit;
        stdoutThread.join();
        stderrThread.join();
        this.mStdout = stdoutGobbler.getContent();
        this.mStderr = stderrGobbler.getContent();
    }

    public Integer getExitCode() {
        return this.mExit;
    }

    public String getStdout() {
        return this.mStdout;
    }

    public String getStderr() {
        return this.mStderr;
    }
}

