/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.exec;

import edu.mayo.exec.AbnormalExitException;
import edu.mayo.exec.BaseCommand;
import edu.mayo.exec.BufferedStreamGobbler;
import edu.mayo.exec.Command;
import edu.mayo.exec.JarUtil;
import edu.mayo.exec.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixStreamCommand
extends BaseCommand {
    private static final Logger sLogger = LoggerFactory.getLogger(UnixStreamCommand.class);
    private Process mProcess;
    private PrintWriter mStdinWriter;
    private BufferedStreamGobbler mStdoutGobbler;
    private Thread mStdoutThread;
    private StreamGobbler mStderrGobbler;
    private Thread mStderrThread;
    private Integer mExit;
    private static String sOperatingSys;
    private static String sMachineArch;

    public UnixStreamCommand(String[] cmdarray, Map<String, String> customEnv, boolean useParentEnv, boolean forceLineBuffering) throws IOException {
        super(forceLineBuffering ? UnixStreamCommand.getModifiedCmdArray(cmdarray) : cmdarray, customEnv, useParentEnv);
    }

    public UnixStreamCommand(String[] cmdarray, Map<String, String> customEnv, boolean useParentEnv, boolean forceLineBuffering, File workingDirectory) throws IOException {
        super(forceLineBuffering ? UnixStreamCommand.getModifiedCmdArray(cmdarray) : cmdarray, customEnv, useParentEnv, workingDirectory);
    }

    private static String[] getModifiedCmdArray(String[] cmdarray) throws IOException {
        ArrayList<String> modifiedCmdArray = new ArrayList<String>();
        modifiedCmdArray.add(UnixStreamCommand.getStdbufBinary().getAbsolutePath());
        modifiedCmdArray.add("--output=L");
        for (String s : cmdarray) {
            modifiedCmdArray.add(s);
        }
        return modifiedCmdArray.toArray(new String[0]);
    }

    public void launch() throws IOException {
        this.mProcess = this.launchProcess();
        this.mStdinWriter = new PrintWriter(new OutputStreamWriter(this.mProcess.getOutputStream()));
        this.mStdoutGobbler = new BufferedStreamGobbler(this.mProcess.getInputStream());
        this.mStdoutThread = new Thread((Runnable)this.mStdoutGobbler, "STDOUT");
        this.mStdoutThread.start();
        sLogger.debug(String.format("Started %s gobbler", this.mStdoutThread.getName()));
        this.mStderrGobbler = new StreamGobbler(this.mProcess.getErrorStream());
        this.mStderrThread = new Thread((Runnable)this.mStderrGobbler, "STDERR");
        this.mStderrThread.start();
        sLogger.debug(String.format("Started %s gobbler", this.mStderrThread.getName()));
    }

    public void send(String line) throws AbnormalExitException, InterruptedException {
        this.mStdinWriter.println(line);
        this.mStdinWriter.flush();
        if (this.mStdinWriter.checkError()) {
            String stderr = this.mStderrGobbler.getContent();
            this.terminate();
            System.err.println("Error: " + stderr);
            throw new AbnormalExitException(stderr);
        }
    }

    public String receive() throws AbnormalExitException, IOException, InterruptedException, BrokenBarrierException, TimeoutException {
        String line = this.mStdoutGobbler.getLastGobbledLine();
        if (line == null) {
            this.terminate();
            throw new AbnormalExitException();
        }
        return line;
    }

    public String receive(long timeout, TimeUnit unit) throws AbnormalExitException, IOException, InterruptedException, BrokenBarrierException, TimeoutException, ExecutionException {
        String line = this.mStdoutGobbler.getLastGobbledLine(timeout, unit);
        if (line == null) {
            this.terminate();
            throw new AbnormalExitException();
        }
        return line;
    }

    public void terminate() throws InterruptedException {
        this.mStdinWriter.close();
        sLogger.debug("Sent signal end-of-transmission to STDIN");
        int exit = this.mProcess.waitFor();
        sLogger.debug(String.format("Process exited with exit code %s", exit));
        this.mExit = exit;
        this.mStderrThread.join();
        this.mStdoutThread.join();
    }

    private static File getStdbufBinary() throws IOException {
        String stdbufPath = String.format("/coreutils-8.21/%s-%s/stdbuf", sOperatingSys, sMachineArch);
        String libstdbufPath = String.format("/coreutils-8.21/%s-%s/libstdbuf.so", sOperatingSys, sMachineArch);
        if (new File(stdbufPath).exists() && new File(libstdbufPath).exists()) {
            return new File(stdbufPath);
        }
        String dirName = "coreutils" + System.nanoTime();
        File tempDir = new File(FileUtils.getTempDirectory(), dirName);
        tempDir.mkdir();
        File stdbuf = new File(tempDir, "stdbuf");
        stdbuf.createNewFile();
        JarUtil.copyFile(stdbufPath, stdbuf);
        stdbuf.setExecutable(true);
        File libstdbuf = new File(tempDir, "libstdbuf.so");
        libstdbuf.createNewFile();
        JarUtil.copyFile(libstdbufPath, libstdbuf);
        tempDir.deleteOnExit();
        stdbuf.deleteOnExit();
        libstdbuf.deleteOnExit();
        return stdbuf;
    }

    public Integer getExitCode() {
        return this.mExit;
    }

    public String getStderr() {
        return this.mStderrGobbler.getContent();
    }

    static {
        String[] cmdarray = new String[]{"uname", "-s"};
        Command c = new Command(cmdarray, Collections.emptyMap(), true);
        try {
            c.execute();
            sOperatingSys = c.getStdout().trim().toLowerCase();
            sLogger.debug(String.format("Operating System: %s", sOperatingSys));
        }
        catch (Exception e) {
            sLogger.error(e.getMessage(), (Throwable)e);
        }
        cmdarray = new String[]{"uname", "-m"};
        c = new Command(cmdarray, Collections.emptyMap(), true);
        try {
            c.execute();
            sMachineArch = c.getStdout().trim().toLowerCase();
            sLogger.debug(String.format("Machine Architecture: %s", sMachineArch));
        }
        catch (Exception e) {
            sLogger.error(e.getMessage(), (Throwable)e);
        }
    }
}

