/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.modify;

import edu.mayo.genomicutils.util.StringUtil;
import edu.mayo.genomicutils.vcf.modify.BaseModifyRowPluginImpl;
import edu.mayo.genomicutils.vcf.modify.InfoFieldMetadata;
import edu.mayo.genomicutils.vcf.modify.ModifyRowPlugin;
import edu.mayo.genomicutils.vcf.modify.VCFParseUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class WebLinkModifyRowPluginImpl
extends BaseModifyRowPluginImpl
implements ModifyRowPlugin {
    private Properties props;
    private List<String> existingInfoFields = new ArrayList<String>();
    private final String PLACEHOLDER = "@@ID@@";

    @Override
    public void init(Properties props) {
        this.props = props;
        for (String name : props.stringPropertyNames()) {
            String value = props.getProperty(name);
            if (value.contains("@@ID@@")) continue;
            String mesg = String.format("The template [%s] does not contain the required placeholder %s", value, "@@ID@@");
            throw new RuntimeException(mesg);
        }
    }

    @Override
    public String modifyMetadataRow(String metadata) {
        if (metadata.startsWith("##INFO")) {
            InfoFieldMetadata infoFieldMetadata = VCFParseUtils.parseInfoMetadata(metadata);
            this.existingInfoFields.add(infoFieldMetadata.id);
        }
        return metadata;
    }

    @Override
    public List<String> getNewMetadataRows() {
        ArrayList<String> newRows = new ArrayList<String>();
        for (String propertyName : this.props.stringPropertyNames()) {
            List<String> expandedValues = StringUtil.expand(Collections.singletonList(propertyName), this.existingInfoFields, false);
            for (String infoFieldID : expandedValues) {
                if (!this.existingInfoFields.contains(infoFieldID)) continue;
                String newInfoFieldID = this.getLinkFieldName(infoFieldID);
                newRows.add(String.format("##INFO=<ID=%s,Number=1,Type=String,Description=\"Link to %s\">", newInfoFieldID, infoFieldID));
            }
        }
        return newRows;
    }

    private String getLinkFieldName(String existingFieldName) {
        return existingFieldName + "_link";
    }

    @Override
    public String[] modifyDataRow(String[] cols) {
        if (!VCFParseUtils.hasInfoColumn(cols)) {
            return cols;
        }
        StringBuilder infoField = new StringBuilder(cols[7]);
        Map<String, String> m = VCFParseUtils.parseInfoField(infoField.toString());
        for (String propertyName : this.props.stringPropertyNames()) {
            String template = this.props.getProperty(propertyName);
            List<String> expandedValues = StringUtil.expand(Collections.singletonList(propertyName), this.existingInfoFields, false);
            for (String infoFieldID : expandedValues) {
                if (!m.containsKey(infoFieldID)) continue;
                String idValue = m.get(infoFieldID);
                String link = template.replaceAll("@@ID@@", idValue);
                infoField.append(";").append(this.getLinkFieldName(infoFieldID)).append("=").append(link);
            }
        }
        String[] modified = new String[cols.length];
        System.arraycopy(cols, 0, modified, 0, cols.length);
        modified[7] = infoField.toString();
        return modified;
    }
}

