/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.filter.cqengine;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.hash.HashIndex;
import com.googlecode.cqengine.index.navigable.NavigableIndex;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.logical.LogicalQuery;
import com.googlecode.cqengine.query.parser.common.InvalidQueryException;
import com.googlecode.cqengine.query.parser.common.ParseResult;
import com.googlecode.cqengine.query.parser.common.ValueParser;
import com.googlecode.cqengine.query.parser.sql.SQLParser;
import com.googlecode.cqengine.query.parser.sql.grammar.SQLGrammarLexer;
import com.googlecode.cqengine.query.parser.sql.grammar.SQLGrammarParser;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import edu.mayo.genomicutils.vcf.filter.cqengine.AttributeSQLAntlrListener;
import edu.mayo.genomicutils.vcf.filter.cqengine.CaseInsensitiveStringValueParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class CQEngineUtil {
    public static String getCaseInsensitiveValue(String s) {
        return s.toUpperCase();
    }

    static Index<Map> getOptimalIndex(Attribute attr) {
        if (attr.getAttributeType().equals(Integer.class) || attr.getAttributeType().equals(Float.class)) {
            return NavigableIndex.onAttribute((Attribute)attr);
        }
        return HashIndex.onAttribute((Attribute)attr);
    }

    static List<SimpleQuery> getAllSimpleQueries(Query q) {
        ArrayList<SimpleQuery> list = new ArrayList<SimpleQuery>();
        if (q instanceof SimpleQuery) {
            list.add((SimpleQuery)q);
        } else if (q instanceof LogicalQuery) {
            LogicalQuery logicalQuery = (LogicalQuery)q;
            Collection children = logicalQuery.getChildQueries();
            for (Query child : children) {
                list.addAll(CQEngineUtil.getAllSimpleQueries(child));
            }
        }
        return list;
    }

    static Set<String> getAttributeNamesInQuery(Query<Map> query) {
        HashSet<String> attrNamesInQuery = new HashSet<String>();
        for (SimpleQuery sq : CQEngineUtil.getAllSimpleQueries(query)) {
            attrNamesInQuery.add(sq.getAttributeName());
        }
        return attrNamesInQuery;
    }

    public static String getAttributeName(String originalName) {
        if (originalName.contains(".")) {
            return "\"" + originalName + "\"";
        }
        return originalName;
    }

    public static String getOriginalName(String attributeName) {
        if (attributeName.startsWith("\"") && attributeName.endsWith("\"")) {
            return attributeName.substring(1, attributeName.length() - 1);
        }
        return attributeName;
    }

    public static Set<String> parseAttributeNames(String sql) throws InvalidQueryException {
        try {
            SQLGrammarLexer lexer = new SQLGrammarLexer((CharStream)new ANTLRInputStream(sql));
            lexer.removeErrorListeners();
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SQLGrammarParser parser = new SQLGrammarParser((TokenStream)tokens);
            parser.removeErrorListeners();
            SQLGrammarParser.StartContext queryContext = parser.start();
            ParseTreeWalker walker = new ParseTreeWalker();
            AttributeSQLAntlrListener listener = new AttributeSQLAntlrListener();
            walker.walk((ParseTreeListener)listener, (ParseTree)queryContext);
            return listener.getAttributeNames();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidQueryException("Failed to parse query", (Throwable)e);
        }
    }

    public static Query<Map> buildQuery(String sqlQuery, Map<String, Attribute<Map, ?>> nameToAttributeMap, boolean valuesCaseSensitive) {
        ParseResult parseResult;
        SQLParser parser = SQLParser.forPojoWithAttributes(Map.class, nameToAttributeMap);
        if (!valuesCaseSensitive) {
            parser.registerValueParser(String.class, (ValueParser)new CaseInsensitiveStringValueParser());
        }
        try {
            parseResult = parser.parse(sqlQuery);
        }
        catch (InvalidQueryException iqe) {
            Throwable cause = iqe.getCause();
            if (cause != null && cause.getMessage().startsWith("No such attribute has been registered with the parser")) {
                throw new InvalidQueryException(cause.getMessage());
            }
            throw iqe;
        }
        return parseResult.getQuery();
    }
}

