/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.filter;

import edu.mayo.genomicutils.vcf.VCFUtils;
import edu.mayo.genomicutils.vcf.filter.Settings;
import edu.mayo.genomicutils.vcf.filter.VariantResultSet;
import edu.mayo.genomicutils.vcf.filter.VariantStore;
import htsjdk.variant.vcf.VCFHeader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCFFilterEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCFFilterEngine.class);
    private BufferedReader reader;
    private PrintWriter writer;
    private VariantStore variantStore;
    private Settings settings;

    public VCFFilterEngine(Reader vcfReader, Writer vcfWriter, VariantStore variantStore, Settings settings) {
        this.reader = new BufferedReader(vcfReader);
        this.writer = new PrintWriter(vcfWriter);
        this.variantStore = variantStore;
        this.settings = settings;
        LOGGER.info(String.format("VCF data row batch size = %s", settings.getBatchSize()));
    }

    public void execute() throws IOException {
        String line;
        ArrayList<String> headerLines = new ArrayList<String>();
        ArrayList<String> dataLines = new ArrayList<String>();
        boolean hasHeaderBeenProcessed = false;
        while ((line = this.reader.readLine()) != null) {
            if (!hasHeaderBeenProcessed && line.startsWith("#")) {
                headerLines.add(line);
                continue;
            }
            if (!hasHeaderBeenProcessed) {
                this.processHeader(headerLines);
                hasHeaderBeenProcessed = true;
            }
            dataLines.add(line);
            if (dataLines.size() != this.settings.getBatchSize()) continue;
            this.processBatch(dataLines);
            dataLines.clear();
        }
        if (!hasHeaderBeenProcessed) {
            this.processHeader(headerLines);
        }
        this.processBatch(dataLines);
        IOUtils.closeQuietly((Reader)this.reader);
        IOUtils.closeQuietly((Writer)this.writer);
    }

    private void processHeader(List<String> headerLines) throws IOException {
        LOGGER.info(String.format("VCF header contains %s lines", headerLines.size()));
        for (String headerLine : headerLines) {
            this.writer.println(headerLine);
        }
        this.writer.flush();
        VCFHeader vcfHeader = VCFUtils.parseHeader(headerLines);
        this.variantStore.init(vcfHeader, true);
    }

    private void processBatch(List<String> batch) throws IOException {
        this.variantStore.clearVariants();
        this.variantStore.loadVariants(batch.iterator());
        VariantResultSet rs = this.variantStore.filterVariants();
        while (rs.next()) {
            this.writer.println(rs.getVCFDataLine());
        }
        this.writer.flush();
    }
}

