/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.calc;

import com.google.gson.JsonArray;
import java.util.Arrays;

public class VariantCalculations {
    public int GenotypePostitiveCount = 0;
    public JsonArray GenotypePositiveSamples = new JsonArray();
    public JsonArray hetrozygus = new JsonArray();
    public JsonArray homozygus = new JsonArray();
    public JsonArray wildtype = new JsonArray();
    private int[] integerMax;
    private int[] integerMin;
    private double[] doubleMax;
    private double[] doubleMin;
    public Totals totalAD;
    private Double configurableDoubleMin;
    private Double configurableDoubleMax;

    public VariantCalculations(int numFormatFields, Double configurableDoubleMin, Double configurableDoubleMax) {
        this.configurableDoubleMin = configurableDoubleMin;
        this.configurableDoubleMax = configurableDoubleMax;
        this.totalAD = new Totals(configurableDoubleMin, configurableDoubleMax);
        this.integerMin = new int[numFormatFields];
        Arrays.fill(this.integerMin, Integer.MAX_VALUE);
        this.integerMax = new int[numFormatFields];
        Arrays.fill(this.integerMax, Integer.MIN_VALUE);
        this.doubleMin = new double[numFormatFields];
        Arrays.fill(this.doubleMin, this.configurableDoubleMax);
        this.doubleMax = new double[numFormatFields];
        Arrays.fill(this.doubleMax, this.configurableDoubleMin);
    }

    public void updateIntegerMinMax(int formatFieldIdx, int intValue) {
        this.integerMin[formatFieldIdx] = intValue < this.integerMin[formatFieldIdx] ? intValue : this.integerMin[formatFieldIdx];
        this.integerMax[formatFieldIdx] = intValue > this.integerMax[formatFieldIdx] ? intValue : this.integerMax[formatFieldIdx];
    }

    public void updateDoubleMinMax(int formatFieldIdx, double doubleValue) {
        this.doubleMin[formatFieldIdx] = doubleValue < this.doubleMin[formatFieldIdx] ? doubleValue : this.doubleMin[formatFieldIdx];
        this.doubleMax[formatFieldIdx] = doubleValue > this.doubleMax[formatFieldIdx] ? doubleValue : this.doubleMax[formatFieldIdx];
    }

    public int getIntegerMin(int formatFieldIdx) throws Exception {
        int value = this.integerMin[formatFieldIdx];
        if (value == Integer.MAX_VALUE) {
            throw new Exception("No integer min");
        }
        return value;
    }

    public int getIntegerMax(int formatFieldIdx) throws Exception {
        int value = this.integerMax[formatFieldIdx];
        if (value == Integer.MIN_VALUE) {
            throw new Exception("No integer max");
        }
        return value;
    }

    public double getDoubleMin(int formatFieldIdx) throws Exception {
        double value = this.doubleMin[formatFieldIdx];
        if (value == this.configurableDoubleMax) {
            throw new Exception("No double min");
        }
        return value;
    }

    public double getDoubleMax(int formatFieldIdx) throws Exception {
        double value = this.doubleMax[formatFieldIdx];
        if (value == this.configurableDoubleMin) {
            throw new Exception("No double max");
        }
        return value;
    }

    public class Totals {
        public double min;
        public double max;

        public Totals(Double configurableDoubleMin, Double configurableDoubleMax) {
            this.min = configurableDoubleMax;
            this.max = configurableDoubleMin;
        }
    }
}

