/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringUtil.class);

    public static List<String> expand(List<String> expandableValues, List<String> availableValues, boolean isCaseSensitive) {
        IOCase caseSensitivity;
        IOCase iOCase = caseSensitivity = isCaseSensitive ? IOCase.SENSITIVE : IOCase.INSENSITIVE;
        if (LOGGER.isDebugEnabled()) {
            StringWriter sWtr = new StringWriter();
            PrintWriter pWtr = new PrintWriter(sWtr);
            pWtr.println(String.format("%s values are available for wildcard expansion:", availableValues.size()));
            for (String availableValue : availableValues) {
                pWtr.println(availableValue);
            }
            LOGGER.debug(sWtr.toString());
        }
        ArrayList<String> expandedValues = new ArrayList<String>();
        for (String expandableValue : expandableValues) {
            ArrayList<String> expansions = new ArrayList<String>();
            for (String availableValue : availableValues) {
                if (FilenameUtils.wildcardMatch((String)availableValue, (String)expandableValue, (IOCase)caseSensitivity)) {
                    LOGGER.info(String.format("Wildcard expression %s expanded to %s", expandableValue, availableValue));
                    expansions.add(availableValue);
                    continue;
                }
                LOGGER.warn(String.format("Wildcard expression %s could not be expanded", expandableValue));
            }
            if (expansions.size() > 0) {
                expandedValues.addAll(expansions);
                continue;
            }
            expandedValues.add(expandableValue);
        }
        return expandedValues;
    }
}

