/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.sideeffect;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupByPipe<S, K, V>
extends AbstractPipe<S, S>
implements SideEffectPipe.GreedySideEffectPipe<S, Map<K, List<V>>> {
    protected Map<K, Collection<V>> byMap;
    protected final PipeFunction<S, K> keyFunction;
    protected final PipeFunction<S, V> valueFunction;

    public GroupByPipe(Map<K, Collection<V>> byMap, PipeFunction<S, K> keyFunction, PipeFunction<S, V> valueFunction) {
        this.byMap = byMap;
        this.keyFunction = keyFunction;
        this.valueFunction = valueFunction;
    }

    public GroupByPipe(PipeFunction<S, K> keyFunction, PipeFunction<S, V> valueFunction) {
        this(new HashMap(), keyFunction, valueFunction);
    }

    @Override
    protected S processNextStart() {
        Object s = this.starts.next();
        K key = this.getKey(s);
        V value = this.getValue(s);
        Collection<V> list = this.byMap.get(key);
        if (null == list) {
            list = new ArrayList<V>();
            this.byMap.put(key, list);
        }
        this.addValue(value, list);
        return (S)s;
    }

    @Override
    public Map getSideEffect() {
        return this.byMap;
    }

    public void addValue(V value, Collection values) {
        if (value instanceof Pipe) {
            PipeHelper.fillCollection((Pipe)value, values);
        } else {
            values.add(value);
        }
    }

    protected K getKey(S start) {
        return (K)(null == this.keyFunction ? start : this.keyFunction.compute(start));
    }

    protected V getValue(S start) {
        return (V)(null == this.valueFunction ? start : this.valueFunction.compute(start));
    }

    @Override
    public void reset() {
        this.byMap = new HashMap<K, Collection<V>>();
        super.reset();
    }
}

