/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.exec;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCommand {
    private static final Logger sLogger = LoggerFactory.getLogger(BaseCommand.class);
    private String[] mEnvironment;
    private String[] mCmdArray;
    private File mWorkingDirectory = null;

    public BaseCommand(String[] cmdarray, Map<String, String> customEnv, boolean useParentEnv) {
        this.setupEnvironment(customEnv, useParentEnv);
        this.mCmdArray = cmdarray;
    }

    public BaseCommand(String[] cmdarray, Map<String, String> customEnv, boolean useParentEnv, File workingDirectory) {
        this.setupEnvironment(customEnv, useParentEnv);
        this.mCmdArray = cmdarray;
        this.mWorkingDirectory = workingDirectory;
    }

    protected Process launchProcess() throws IOException {
        if (sLogger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Launching process:");
            sb.append('\n');
            for (String s : this.mCmdArray) {
                sb.append(s);
                sb.append(' ');
            }
            sLogger.debug(sb.toString());
        }
        Process p = Runtime.getRuntime().exec(this.mCmdArray, this.mEnvironment, this.mWorkingDirectory);
        sLogger.debug("Process started");
        return p;
    }

    private void setupEnvironment(Map<String, String> customEnv, boolean useParentEnv) {
        HashMap<String, String> env = new HashMap<String, String>();
        if (useParentEnv) {
            env.putAll(System.getenv());
        }
        env.putAll(customEnv);
        this.mEnvironment = this.translateMapToStrings(env);
    }

    private String[] translateMapToStrings(Map<String, String> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            String val = map.get(key);
            list.add(key + "=" + val);
        }
        return list.toArray(new String[0]);
    }
}

