/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Predicate;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PropertyFilteredIterable<T extends Element>
implements CloseableIterable<T> {
    private final Iterable<T> iterable;
    private final HasContainer hasContainer;

    public PropertyFilteredIterable(String key, Object value, Iterable<T> iterable) {
        this.iterable = iterable;
        this.hasContainer = new HasContainer(key, Compare.EQUAL, value);
    }

    @Override
    public void close() {
        if (this.iterable instanceof CloseableIterable) {
            ((CloseableIterable)this.iterable).close();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Iterator<T> itty;
            private T nextElement;
            {
                this.itty = PropertyFilteredIterable.this.iterable.iterator();
                this.nextElement = null;
            }

            @Override
            public void remove() {
                this.itty.remove();
            }

            @Override
            public boolean hasNext() {
                if (null != this.nextElement) {
                    return true;
                }
                try {
                    Element element;
                    do {
                        element = (Element)this.itty.next();
                    } while (!PropertyFilteredIterable.this.hasContainer.isLegal(element));
                    this.nextElement = element;
                    return true;
                }
                catch (NoSuchElementException e) {
                    this.nextElement = null;
                    return false;
                }
            }

            @Override
            public T next() {
                Element element;
                if (null != this.nextElement) {
                    Object temp = this.nextElement;
                    this.nextElement = null;
                    return temp;
                }
                do {
                    element = (Element)this.itty.next();
                } while (!PropertyFilteredIterable.this.hasContainer.isLegal(element));
                return element;
            }
        };
    }

    protected class HasContainer {
        public String key;
        public Object value;
        public Predicate predicate;

        public HasContainer(String key, Predicate predicate, Object value) {
            this.key = key;
            this.value = value;
            this.predicate = predicate;
        }

        public boolean isLegal(Element element) {
            if (this.key.equals("id")) {
                return this.predicate.evaluate(element.getId(), this.value);
            }
            if (this.key.equals("label") && element instanceof Edge) {
                return this.predicate.evaluate(((Edge)element).getLabel(), this.value);
            }
            return this.predicate.evaluate(element.getProperty(this.key), this.value);
        }
    }
}

