/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.sage;

import com.google.common.base.Preconditions;
import edu.mayo.sage.SagePropertyException;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UsageLoggerUtils {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final int UC_LENGTH = 4;
    private static final int MAX_MSG_LENGTH = 65536;
    protected static Logger logger = LoggerFactory.getLogger((String)UsageLoggerUtils.class.getName());

    private UsageLoggerUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Object> arrayToMap(Object[] data) {
        if (data.length % 2 == 1) {
            throw new IllegalArgumentException("Programmer error: the array of key-value pairs was of an odd length");
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(data.length / 2);
        int count = 0;
        String key = null;
        for (Object object : data) {
            if (count % 2 == 0) {
                if (!(object instanceof String)) throw new IllegalArgumentException("Programmer error: the key was not of type string for argument #" + (count + 1));
                key = (String)object;
            } else {
                map.put(key, object);
            }
            ++count;
        }
        return map;
    }

    public static String findValueFromEnvironment(String propertyName, String defaultValue) {
        String value = System.getenv(propertyName);
        if (value != null) {
            return value;
        }
        return System.getProperty(propertyName, defaultValue);
    }

    public static byte[] mapToJsonByteArray(Map<String, Object> data) {
        StringBuilder sb = new StringBuilder();
        UsageLoggerUtils.appendValue(sb, data);
        sb.append('\n');
        return sb.toString().getBytes(UTF_8);
    }

    private static void appendValue(StringBuilder sb, Object value) {
        if (value == null) {
            UsageLoggerUtils.escape(sb, "null");
        } else if (value instanceof String) {
            UsageLoggerUtils.appendString(sb, (String)value);
        } else if (value instanceof Number) {
            UsageLoggerUtils.escape(sb, ((Number)value).toString());
        } else if (value instanceof Boolean) {
            UsageLoggerUtils.escape(sb, ((Boolean)value).toString());
        } else if (value instanceof Date) {
            UsageLoggerUtils.appendString(sb, UsageLoggerUtils.dateToIso8601((Date)value));
        } else if (value instanceof Map) {
            UsageLoggerUtils.appendMap(sb, (Map)value);
        } else if (value instanceof Iterable) {
            UsageLoggerUtils.appendIterable(sb, (Iterable)value);
        } else {
            UsageLoggerUtils.appendString(sb, value.toString());
        }
    }

    private static void appendString(StringBuilder sb, String value) {
        sb.append('\"');
        UsageLoggerUtils.escape(sb, value);
        sb.append('\"');
    }

    private static void appendIterable(StringBuilder sb, Iterable value) {
        sb.append('[');
        boolean comma = false;
        for (Object item : value) {
            if (comma) {
                sb.append(',');
            }
            comma = true;
            UsageLoggerUtils.appendValue(sb, item);
        }
        sb.append(']');
    }

    private static void appendMap(StringBuilder sb, Map<String, Object> map) {
        int mapLength = map.toString().length();
        boolean isCloseToOrOverMsgLimit = 65536 - mapLength < 2000;
        ArrayList<Map.Entry<String, Object>> listOfMapPairs = isCloseToOrOverMsgLimit ? UsageLoggerUtils.getMapSortedShortestToLongest(map) : new ArrayList<Map.Entry<String, Object>>(map.entrySet());
        sb.append("{");
        boolean isCommaNeeded = false;
        boolean isOverSizeLimit = false;
        for (Map.Entry entry : listOfMapPairs) {
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            String valAsStr = val == null ? "null" : val.toString();
            int lenExtras = 7 + (isCommaNeeded ? 1 : 0) + 29;
            int msgPlusKeyLen = sb.length() + key.length() + lenExtras;
            int msgPlusKeyValLen = sb.length() + key.length() + valAsStr.length() + lenExtras;
            String val100PlusEllipsis = UsageLoggerUtils.getFirst100CharsPlusEllipsisIfLonger(valAsStr);
            if (msgPlusKeyLen > 65536) {
                UsageLoggerUtils.warnMsgSizeExceedsLimit_key(sb, key, val100PlusEllipsis);
                break;
            }
            if (msgPlusKeyValLen > 65536) {
                int valLenTruncated = 65536 - msgPlusKeyLen - 3;
                val = UsageLoggerUtils.getFirstXCharsPlusEllipsisIfLonger(valAsStr, valLenTruncated);
                UsageLoggerUtils.warnMsgSizeExceedsLimit_value(sb, key, val100PlusEllipsis);
                isOverSizeLimit = true;
            }
            if (isCommaNeeded) {
                sb.append(',');
            }
            isCommaNeeded = true;
            UsageLoggerUtils.appendString(sb, key);
            sb.append(':');
            UsageLoggerUtils.appendValue(sb, val);
            if (!isOverSizeLimit) continue;
            break;
        }
        sb.append("}");
    }

    private static void warnMsgSizeExceedsLimit_key(StringBuilder sb, String key, String val100PlusEllipsis) {
        logger.warn("Warning:  Sage logging message limit length exceeded.  Even the key does not fit.  This entry will not be logged:\nKey:   " + key + "\nValue: " + val100PlusEllipsis + "\nJSON:  " + sb.toString());
    }

    private static void warnMsgSizeExceedsLimit_value(StringBuilder sb, String key, String val100PlusEllipsis) {
        logger.warn("Warning:  Sage logging message limit length exceeded.  The value for this entry will be truncated, and any other key-value pairs for this one instance will be dropped:\nKey:   " + key + "\nValue: " + val100PlusEllipsis + "\nJSON:  " + sb.toString());
    }

    private static String getFirstXCharsPlusEllipsisIfLonger(String s, int len) {
        if (s.length() <= len) {
            return s;
        }
        return s.substring(0, len) + "...";
    }

    private static String getFirst100CharsPlusEllipsisIfLonger(String s) {
        return UsageLoggerUtils.getFirstXCharsPlusEllipsisIfLonger(s, 100);
    }

    private static List<Map.Entry<String, Object>> getMapSortedShortestToLongest(Map<String, Object> map) {
        ArrayList<Map.Entry<String, Object>> listSortedShortestToLongest = new ArrayList<Map.Entry<String, Object>>(map.entrySet());
        Collections.sort(listSortedShortestToLongest, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                int len1 = (o1.getKey() + o1.getValue()).length();
                int len2 = (o2.getKey() + o2.getValue()).length();
                return Integer.compare(len1, len2);
            }
        });
        return listSortedShortestToLongest;
    }

    private static String dateToIso8601(Date value) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        simpleDateFormat.setTimeZone(UTC);
        return simpleDateFormat.format(value);
    }

    static void escape(StringBuilder sb, String s) {
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
    }

    public static String getUsername() {
        return System.getProperty("user.name");
    }

    public static long getHeapSize() {
        return Runtime.getRuntime().totalMemory();
    }

    public static int getProcessID() {
        int pid;
        try {
            pid = Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
        }
        catch (NumberFormatException e) {
            pid = -1;
        }
        return pid;
    }

    public static int intFromString(String portStringValue, String propName) throws SagePropertyException {
        Preconditions.checkNotNull((Object)portStringValue);
        try {
            return new Integer(portStringValue.trim());
        }
        catch (NumberFormatException e) {
            String msg = String.format("%s from %s should be an integer", portStringValue, propName);
            throw new SagePropertyException(msg);
        }
    }

    public static boolean booleanFromString(String booleanStringValue, String propName) throws SagePropertyException {
        Preconditions.checkNotNull((Object)booleanStringValue);
        if ("true".equalsIgnoreCase(booleanStringValue.trim())) {
            return true;
        }
        if ("false".equalsIgnoreCase(booleanStringValue.trim())) {
            return false;
        }
        String msg = String.format("%s from %s should be true/false (case insensitive)", booleanStringValue, propName);
        throw new SagePropertyException(msg);
    }
}

