/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.attribute.support;

import com.googlecode.cqengine.attribute.Attribute;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class AbstractAttribute<O, A>
implements Attribute<O, A> {
    private final Class<O> objectType;
    private final Class<A> attributeType;
    private final String attributeName;
    private final int cachedHashCode;

    public AbstractAttribute() {
        this.attributeName = "<Unnamed attribute, " + this.getClass() + ">";
        this.objectType = AbstractAttribute.readGenericObjectType(this.getClass(), this.attributeName);
        this.attributeType = AbstractAttribute.readGenericAttributeType(this.getClass(), this.attributeName);
        this.cachedHashCode = this.calcHashCode();
    }

    public AbstractAttribute(String attributeName) {
        this.attributeName = attributeName;
        this.objectType = AbstractAttribute.readGenericObjectType(this.getClass(), attributeName);
        this.attributeType = AbstractAttribute.readGenericAttributeType(this.getClass(), attributeName);
        this.cachedHashCode = this.calcHashCode();
    }

    protected AbstractAttribute(Class<O> objectType, Class<A> attributeType) {
        this.attributeName = "<Unnamed attribute, " + this.getClass() + ">";
        this.objectType = objectType;
        this.attributeType = attributeType;
        this.cachedHashCode = this.calcHashCode();
    }

    protected AbstractAttribute(Class<O> objectType, Class<A> attributeType, String attributeName) {
        this.attributeName = attributeName;
        this.objectType = objectType;
        this.attributeType = attributeType;
        this.cachedHashCode = this.calcHashCode();
    }

    @Override
    public Class<O> getObjectType() {
        return this.objectType;
    }

    @Override
    public Class<A> getAttributeType() {
        return this.attributeType;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    public String toString() {
        return "Attribute{objectType=" + this.objectType + ", attributeType=" + this.attributeType + ", attributeName='" + this.attributeName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractAttribute)) {
            return false;
        }
        AbstractAttribute that = (AbstractAttribute)o;
        if (!that.canEqual(this)) {
            return false;
        }
        if (!this.attributeName.equals(that.attributeName)) {
            return false;
        }
        if (!this.attributeType.equals(that.attributeType)) {
            return false;
        }
        return this.objectType.equals(that.objectType);
    }

    public boolean canEqual(Object other) {
        return other instanceof AbstractAttribute;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    protected int calcHashCode() {
        int result = this.objectType.hashCode();
        result = 31 * result + this.attributeType.hashCode();
        result = 31 * result + this.attributeName.hashCode();
        return result;
    }

    static <O> Class<O> readGenericObjectType(Class<?> attributeClass, String attributeName) {
        try {
            Class cls;
            ParameterizedType superclass = (ParameterizedType)attributeClass.getGenericSuperclass();
            Type actualType = superclass.getActualTypeArguments()[0];
            if (actualType instanceof ParameterizedType) {
                Class actualClass;
                ParameterizedType parameterizedType = (ParameterizedType)actualType;
                cls = actualClass = (Class)parameterizedType.getRawType();
            } else {
                Class actualClass;
                cls = actualClass = (Class)actualType;
            }
            return cls;
        }
        catch (Exception e) {
            String attributeClassStr = attributeName.startsWith("<Unnamed attribute, class ") ? "" : " (" + attributeClass + ")";
            throw new IllegalStateException("Attribute '" + attributeName + "'" + attributeClassStr + " is invalid, cannot read generic type information from it. Attributes should typically EITHER be declared in code with generic type information as a (possibly anonymous) subclass of one of the provided attribute types, OR you can use a constructor of the attribute which allows the types to be specified manually.");
        }
    }

    static <A> Class<A> readGenericAttributeType(Class<?> attributeClass, String attributeName) {
        try {
            Class cls;
            ParameterizedType superclass = (ParameterizedType)attributeClass.getGenericSuperclass();
            Type actualType = superclass.getActualTypeArguments()[1];
            if (actualType instanceof ParameterizedType) {
                Class actualClass;
                ParameterizedType parameterizedType = (ParameterizedType)actualType;
                cls = actualClass = (Class)parameterizedType.getRawType();
            } else {
                Class actualClass;
                cls = actualClass = (Class)actualType;
            }
            return cls;
        }
        catch (Exception e) {
            String attributeClassStr = attributeName.startsWith("<Unnamed attribute, class ") ? "" : " (" + attributeClass + ")";
            throw new IllegalStateException("Attribute '" + attributeName + "'" + attributeClassStr + " is invalid, cannot read generic type information from it. Attributes should typically EITHER be declared in code with generic type information as a (possibly anonymous) subclass of one of the provided attribute types, OR you can use a constructor of the attribute which allows the types to be specified manually.");
        }
    }
}

