/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.externalsorting.csv;

import java.nio.charset.Charset;
import java.util.Comparator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;

public class CsvSortOptions {
    private final Comparator<CSVRecord> comparator;
    private final int maxTmpFiles;
    private final long maxMemory;
    private final Charset charset;
    private final boolean distinct;
    private final int numHeader;
    private final boolean skipHeader;
    private final CSVFormat format;

    public Comparator<CSVRecord> getComparator() {
        return this.comparator;
    }

    public int getMaxTmpFiles() {
        return this.maxTmpFiles;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public int getNumHeader() {
        return this.numHeader;
    }

    public boolean isSkipHeader() {
        return this.skipHeader;
    }

    public CSVFormat getFormat() {
        return this.format;
    }

    private CsvSortOptions(Builder builder) {
        this.comparator = builder.cmp;
        this.maxTmpFiles = builder.maxTmpFiles;
        this.maxMemory = builder.maxMemory;
        this.charset = builder.cs;
        this.distinct = builder.distinct;
        this.numHeader = builder.numHeader;
        this.skipHeader = builder.skipHeader;
        this.format = builder.format;
    }

    public static class Builder {
        private final Comparator<CSVRecord> cmp;
        private final int maxTmpFiles;
        private final long maxMemory;
        private Charset cs = Charset.defaultCharset();
        private boolean distinct = false;
        private int numHeader = 0;
        private boolean skipHeader = true;
        private CSVFormat format = CSVFormat.DEFAULT;

        public Builder(Comparator<CSVRecord> cmp, int maxTmpFiles, long maxMemory) {
            this.cmp = cmp;
            this.maxTmpFiles = maxTmpFiles;
            this.maxMemory = maxMemory;
        }

        public Builder charset(Charset value) {
            this.cs = value;
            return this;
        }

        public Builder distinct(boolean value) {
            this.distinct = value;
            return this;
        }

        public Builder numHeader(int value) {
            this.numHeader = value;
            return this;
        }

        public Builder skipHeader(boolean value) {
            this.skipHeader = value;
            return this;
        }

        public Builder format(CSVFormat value) {
            this.format = value;
            return this;
        }

        public CsvSortOptions build() {
            return new CsvSortOptions(this);
        }
    }
}

