/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.modify;

import edu.mayo.genomicutils.vcf.modify.InfoFieldMetadata;
import java.util.HashMap;
import java.util.Map;

public class VCFParseUtils {
    public static boolean hasInfoColumn(String[] cols) {
        return cols.length != 0 && cols[0].charAt(0) != '#' && cols.length >= 8;
    }

    public static boolean hasSamples(String[] cols) {
        return cols.length != 0 && cols[0].charAt(0) != '#' && cols.length > 9;
    }

    public static Map<String, String> parseInfoField(String infoField) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (String pairing : infoField.split(";")) {
            if (!pairing.contains("=")) continue;
            int eqIdx = pairing.indexOf(61);
            String id = pairing.substring(0, eqIdx);
            String value = pairing.substring(eqIdx + 1, pairing.length());
            m.put(id, value);
        }
        return m;
    }

    public static InfoFieldMetadata parseInfoMetadata(String infoFieldMetadata) {
        InfoFieldMetadata metadata = new InfoFieldMetadata();
        int lessThanIdx = infoFieldMetadata.indexOf(60);
        int greaterThanIdx = infoFieldMetadata.lastIndexOf(62);
        if (lessThanIdx != -1 && greaterThanIdx != -1) {
            String metadataFieldsStr = infoFieldMetadata.substring(lessThanIdx + 1, greaterThanIdx);
            int lastIdx = 0;
            int commaIdx = metadataFieldsStr.indexOf(",");
            while (commaIdx != -1) {
                String field = metadataFieldsStr.substring(lastIdx, commaIdx).trim();
                int equalsIdx = field.indexOf("=");
                if (equalsIdx != -1) {
                    String name = field.substring(0, equalsIdx).trim();
                    String value = field.substring(equalsIdx + 1, field.length()).trim();
                    if (name.equalsIgnoreCase("ID")) {
                        metadata.id = value;
                    } else if (name.equalsIgnoreCase("Number")) {
                        metadata.number = value;
                    } else if (name.equalsIgnoreCase("Type")) {
                        metadata.type = value;
                    } else if (name.equalsIgnoreCase("Description")) {
                        StringBuffer sb = new StringBuffer(value);
                        sb.deleteCharAt(0);
                        sb.deleteCharAt(sb.length() - 1);
                        metadata.description = sb.toString();
                    }
                }
                if ((commaIdx = metadataFieldsStr.indexOf(44, lastIdx = commaIdx + 1)) != -1 || lastIdx >= metadataFieldsStr.length()) continue;
                commaIdx = metadataFieldsStr.length();
            }
        }
        return metadata;
    }
}

