/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.modify;

import edu.mayo.genomicutils.vcf.modify.BaseModifyRowPluginImpl;
import edu.mayo.genomicutils.vcf.modify.ModifyRowPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GenotypeModifyRowPluginImpl
extends BaseModifyRowPluginImpl
implements ModifyRowPlugin {
    private static final String COLON = ":";
    private boolean hasSamples = false;
    private List<String> sampleNames = new ArrayList<String>();
    private Integer gtFieldPosition = null;

    @Override
    public String[] modifyColumnHeaderRow(String[] colNames) {
        if (colNames.length > 9) {
            this.hasSamples = true;
            this.sampleNames.addAll(Arrays.asList(colNames).subList(9, colNames.length));
        }
        return colNames;
    }

    @Override
    public List<String> getNewMetadataRows() {
        ArrayList<String> newRows = new ArrayList<String>();
        for (String sampleName : this.sampleNames) {
            String gtField = this.getGenotypeFieldName(sampleName);
            newRows.add(String.format("##INFO=<ID=%s,Number=1,Type=String,Description=\"Genotype for sample %s\">", gtField, sampleName));
        }
        return newRows;
    }

    private String getGenotypeFieldName(String sampleName) {
        return sampleName + "_GT";
    }

    @Override
    public String[] modifyDataRow(String[] cols) {
        if (!this.hasSamples) {
            return cols;
        }
        if (this.gtFieldPosition == null) {
            this.gtFieldPosition = this.locateGT(cols[8]);
        }
        if (this.gtFieldPosition != null) {
            StringBuilder infoField = new StringBuilder(cols[7]);
            int sampleOrdinal = 0;
            for (String sampleName : this.sampleNames) {
                String gt = cols[8 + ++sampleOrdinal].split(COLON, -1)[this.gtFieldPosition];
                infoField.append(";").append(this.getGenotypeFieldName(sampleName)).append("=").append(gt);
            }
            String[] modified = new String[cols.length];
            System.arraycopy(cols, 0, modified, 0, cols.length);
            modified[7] = infoField.toString();
            return modified;
        }
        return cols;
    }

    private Integer locateGT(String formatCol) {
        String[] arr = formatCol.split(COLON, -1);
        for (int pos = 0; pos < arr.length; ++pos) {
            if (!arr[pos].equalsIgnoreCase("GT")) continue;
            return pos;
        }
        return null;
    }
}

