/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.filter.cqengine.plugin;

import edu.mayo.genomicutils.util.CollectionsUtil;
import edu.mayo.genomicutils.vcf.VCFUtils;
import edu.mayo.genomicutils.vcf.filter.cqengine.AttributeType;
import edu.mayo.genomicutils.vcf.filter.cqengine.CQEngineUtil;
import edu.mayo.genomicutils.vcf.filter.cqengine.IndexableObject;
import edu.mayo.genomicutils.vcf.filter.cqengine.plugin.VCFTransformPlugin;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InfoVCFTransformPluginImpl
implements VCFTransformPlugin {
    static final int BOOLEAN_FALSE = 0;
    static final int BOOLEAN_TRUE = 1;
    private VCFHeader vcfHeader;

    @Override
    public void init(VCFHeader header) {
        this.vcfHeader = header;
    }

    @Override
    public Map<String, AttributeType> getFields() {
        HashMap<String, AttributeType> m = new HashMap<String, AttributeType>();
        block7: for (VCFInfoHeaderLine infoLine : this.vcfHeader.getInfoHeaderLines()) {
            String attrName = CQEngineUtil.getAttributeName(infoLine.getID());
            switch (infoLine.getType()) {
                case Character: {
                    m.put(attrName, AttributeType.CHARACTER_ARRAY);
                    continue block7;
                }
                case Flag: {
                    m.put(attrName, AttributeType.INTEGER);
                    continue block7;
                }
                case Float: {
                    m.put(attrName, AttributeType.FLOAT_ARRAY);
                    continue block7;
                }
                case Integer: {
                    m.put(attrName, AttributeType.INTEGER_ARRAY);
                    continue block7;
                }
                case String: {
                    m.put(attrName, AttributeType.STRING_ARRAY);
                    continue block7;
                }
            }
            throw new RuntimeException(String.format("Unsupported type: %s", infoLine.getType().toString()));
        }
        return m;
    }

    @Override
    public IndexableObject getObject(String[] vcfRow, Set<String> attrNamesInQuery) {
        return this.toIndexableObject(this.vcfHeader, vcfRow, attrNamesInQuery);
    }

    private IndexableObject toIndexableObject(VCFHeader header, String[] vcfRow, Set<String> attrNamesInQuery) {
        IndexableObject indexableObj = new IndexableObject();
        for (String attrName : attrNamesInQuery) {
            Object attrVal;
            String infoFieldID = CQEngineUtil.getOriginalName(attrName);
            Map<String, Object> infoMap = VCFUtils.parseInfo(header, vcfRow[7]);
            VCFInfoHeaderLine infoLine = header.getInfoHeaderLine(infoFieldID);
            if (infoLine == null) continue;
            List<String> infoFieldVal = infoMap.get(infoFieldID);
            boolean isNull = infoFieldVal == null;
            switch (infoLine.getType()) {
                case Character: {
                    attrVal = infoFieldVal instanceof ArrayList ? CollectionsUtil.toCharacterList(infoFieldVal) : (isNull ? Collections.EMPTY_LIST : CollectionsUtil.toCharacterList(Collections.singletonList((String)((Object)infoFieldVal))));
                    break;
                }
                case Flag: {
                    attrVal = infoFieldVal == null ? 0 : 1;
                    break;
                }
                case Float: {
                    attrVal = infoFieldVal instanceof ArrayList ? CollectionsUtil.toFloatList(infoFieldVal) : (isNull ? Collections.EMPTY_LIST : CollectionsUtil.toFloatList(Collections.singletonList((String)((Object)infoFieldVal))));
                    break;
                }
                case Integer: {
                    attrVal = infoFieldVal instanceof ArrayList ? CollectionsUtil.toIntegerList(infoFieldVal) : (isNull ? Collections.EMPTY_LIST : CollectionsUtil.toIntegerList(Collections.singletonList((String)((Object)infoFieldVal))));
                    break;
                }
                case String: {
                    if (infoFieldVal instanceof ArrayList) {
                        for (int i = 0; i < ((ArrayList)infoFieldVal).size(); ++i) {
                            ((ArrayList)infoFieldVal).set(i, VCFUtils.decodeInfoFieldValues((String)((ArrayList)infoFieldVal).get(i)));
                        }
                    }
                    attrVal = infoFieldVal instanceof ArrayList ? infoFieldVal : (isNull ? Collections.EMPTY_LIST : Collections.singletonList(VCFUtils.decodeInfoFieldValues(infoFieldVal.toString())));
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Unsupported type: %s", infoLine.getType().toString()));
                }
            }
            if (attrVal.equals(Collections.EMPTY_LIST)) continue;
            indexableObj.put(attrName, attrVal);
        }
        return indexableObj;
    }
}

