/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.filter.cqengine.plugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import edu.mayo.genomicutils.vcf.calc.VariantCalculations;
import edu.mayo.genomicutils.vcf.calc.VariantCalculator;
import edu.mayo.genomicutils.vcf.filter.cqengine.AttributeType;
import edu.mayo.genomicutils.vcf.filter.cqengine.IndexableObject;
import edu.mayo.genomicutils.vcf.filter.cqengine.plugin.VCFTransformPlugin;
import edu.mayo.genomicutils.vcf.header.HeaderFieldDefinition;
import htsjdk.variant.vcf.VCFHeader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenotypeVCFTransformPluginImpl
implements VCFTransformPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenotypeVCFTransformPluginImpl.class);
    public static final String ATTR_GT_POS_CNT = "GenotypePositiveCount";
    public static final String ATTR_GT_POS = "GenotypePositiveSamples";
    public static final String ATTR_GT_HET = "HeterozygousSamples";
    public static final String ATTR_GT_HOM = "HomozygousSamples";
    public static final String ATTR_GT_WT = "WildtypeSamples";
    private VariantCalculator variantCalculator;

    @Override
    public void init(VCFHeader header) {
        String[] sampleNames = this.getSampleNames(header);
        ArrayList<HeaderFieldDefinition> noDefs = new ArrayList<HeaderFieldDefinition>();
        this.variantCalculator = new VariantCalculator(sampleNames, (Collection<HeaderFieldDefinition>)noDefs, (Double)Double.MIN_VALUE, (Double)Double.MAX_VALUE);
    }

    @Override
    public Map<String, AttributeType> getFields() {
        HashMap<String, AttributeType> m = new HashMap<String, AttributeType>();
        m.put(ATTR_GT_POS_CNT, AttributeType.INTEGER);
        m.put(ATTR_GT_POS, AttributeType.STRING_ARRAY);
        m.put(ATTR_GT_HET, AttributeType.STRING_ARRAY);
        m.put(ATTR_GT_HOM, AttributeType.STRING_ARRAY);
        m.put(ATTR_GT_WT, AttributeType.STRING_ARRAY);
        return m;
    }

    @Override
    public IndexableObject getObject(String[] vcfRow, Set<String> attrNamesInQuery) {
        VariantCalculations calculations;
        IndexableObject indexableObj = new IndexableObject();
        if (vcfRow.length <= 9) {
            return indexableObj;
        }
        try {
            calculations = this.variantCalculator.calculate(vcfRow);
        }
        catch (ParseException e) {
            LOGGER.error(String.format("Error processing VCF row: %s", ArrayUtils.toString((Object)vcfRow)));
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (attrNamesInQuery.contains(ATTR_GT_POS_CNT)) {
            indexableObj.put(ATTR_GT_POS_CNT, calculations.GenotypePostitiveCount);
        }
        if (attrNamesInQuery.contains(ATTR_GT_POS)) {
            indexableObj.put(ATTR_GT_POS, this.toList(calculations.GenotypePositiveSamples));
        }
        if (attrNamesInQuery.contains(ATTR_GT_HET)) {
            indexableObj.put(ATTR_GT_HET, this.toList(calculations.hetrozygus));
        }
        if (attrNamesInQuery.contains(ATTR_GT_HOM)) {
            indexableObj.put(ATTR_GT_HOM, this.toList(calculations.homozygus));
        }
        if (attrNamesInQuery.contains(ATTR_GT_WT)) {
            indexableObj.put(ATTR_GT_WT, this.toList(calculations.wildtype));
        }
        return indexableObj;
    }

    private List<String> toList(JsonArray array) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator itr = array.iterator();
        while (itr.hasNext()) {
            list.add(((JsonElement)itr.next()).getAsString());
        }
        return list;
    }

    private String[] getSampleNames(VCFHeader vcfHeader) {
        List sampleNames = vcfHeader.getGenotypeSamples();
        return sampleNames.toArray(new String[sampleNames.size()]);
    }
}

