/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.filter.cqengine;

import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.option.DeduplicationOption;
import com.googlecode.cqengine.query.option.DeduplicationStrategy;
import com.googlecode.cqengine.resultset.ResultSet;
import edu.mayo.genomicutils.vcf.filter.VariantResultSet;
import edu.mayo.genomicutils.vcf.filter.VariantStore;
import edu.mayo.genomicutils.vcf.filter.cqengine.AttributeFactory;
import edu.mayo.genomicutils.vcf.filter.cqengine.AttributeType;
import edu.mayo.genomicutils.vcf.filter.cqengine.CQEngineUtil;
import edu.mayo.genomicutils.vcf.filter.cqengine.CQEngineVariantResultSetImpl;
import edu.mayo.genomicutils.vcf.filter.cqengine.IndexableObject;
import edu.mayo.genomicutils.vcf.filter.cqengine.SqlPreProcessor;
import edu.mayo.genomicutils.vcf.filter.cqengine.plugin.MissingVCFTransformPluginImpl;
import edu.mayo.genomicutils.vcf.filter.cqengine.plugin.VCFTransformPlugin;
import htsjdk.variant.vcf.VCFHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQEngineVariantStoreImpl
implements VariantStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(CQEngineVariantStoreImpl.class);
    private static final String TAB_REGEX = "\\t";
    private static final String VCF_LINE_KEY = "vcf_line_key";
    private List<VCFTransformPlugin> plugins;
    private IndexedCollection<Map> indexedCollection = new ConcurrentIndexedCollection();
    private Query<Map> query;
    private VariantTableHelper variantTableHelper;

    public CQEngineVariantStoreImpl(String sqlQuery, List<VCFTransformPlugin> plugins) throws IllegalArgumentException {
        this(sqlQuery, plugins, true);
    }

    public CQEngineVariantStoreImpl(String sqlQuery, List<VCFTransformPlugin> plugins, boolean valuesCaseSensitive) throws IllegalArgumentException {
        if (sqlQuery == null || sqlQuery.isEmpty()) {
            throw new IllegalArgumentException("Query was null or empty");
        }
        this.plugins = new ArrayList<VCFTransformPlugin>(plugins);
        this.variantTableHelper = new VariantTableHelper(sqlQuery, valuesCaseSensitive);
    }

    @Override
    public void init(VCFHeader header, boolean ignoreMissingAttributes) {
        Set<String> missingAttributes;
        Map<String, AttributeType> fieldMetadata;
        for (VCFTransformPlugin plugin : this.plugins) {
            plugin.init(header);
            fieldMetadata = plugin.getFields();
            this.loadFieldMetadata(this.variantTableHelper, fieldMetadata);
        }
        if (ignoreMissingAttributes && !(missingAttributes = this.variantTableHelper.getMissingColumns()).isEmpty()) {
            MissingVCFTransformPluginImpl missingPlugin = new MissingVCFTransformPluginImpl();
            missingPlugin.setFields(missingAttributes);
            this.plugins.add(missingPlugin);
            LOGGER.info(String.format("Added %s to list of transform plugins", MissingVCFTransformPluginImpl.class.getName()));
            fieldMetadata = missingPlugin.getFields();
            this.loadFieldMetadata(this.variantTableHelper, fieldMetadata);
        }
        this.query = this.variantTableHelper.getQuery();
        this.addIndexes(this.variantTableHelper.getQueryColumnNames(), this.variantTableHelper.getTableColumnNameToAttributeMap());
    }

    private void loadFieldMetadata(VariantTableHelper variantTableHelper, Map<String, AttributeType> fieldMetadata) {
        for (String attributeName : fieldMetadata.keySet()) {
            AttributeType attributeType = fieldMetadata.get(attributeName);
            variantTableHelper.addTableColumn(attributeName, attributeType);
        }
    }

    private void addIndexes(Collection<String> attributesToIndex, Map<String, Attribute<Map, ?>> nameToAttributeMap) {
        for (String attrName : attributesToIndex) {
            Attribute<Map, ?> attr = nameToAttributeMap.get(attrName);
            Index<Map> index = CQEngineUtil.getOptimalIndex(attr);
            this.indexedCollection.addIndex(index);
            LOGGER.info(String.format("Added %s index to %s", index.getClass(), attrName));
        }
    }

    @Override
    public void loadVariants(Iterator<String> vcfDataLines) {
        while (vcfDataLines.hasNext()) {
            String vcfDataLine = vcfDataLines.next();
            IndexableObject entireRow = this.transform(vcfDataLine);
            entireRow.put(VCF_LINE_KEY, vcfDataLine);
            this.indexedCollection.add((Object)QueryFactory.mapEntity((Map)entireRow));
        }
    }

    private IndexableObject transform(String vcfDataLine) {
        IndexableObject mergedObject = new IndexableObject();
        String[] vcfColumns = vcfDataLine.split(TAB_REGEX, -1);
        for (VCFTransformPlugin plugin : this.plugins) {
            IndexableObject indexableObject = plugin.getObject(vcfColumns, this.variantTableHelper.getQueryColumnNames());
            IndexableObject caseCorrectedObject = this.variantTableHelper.caseCorrectObject(indexableObject);
            Set attributeNames = caseCorrectedObject.keySet();
            for (String attributeName : attributeNames) {
                mergedObject.put(attributeName, caseCorrectedObject.get(attributeName));
            }
        }
        return mergedObject;
    }

    @Override
    public void clearVariants() {
        this.indexedCollection.clear();
    }

    @Override
    public VariantResultSet filterVariants() {
        DeduplicationOption deduplication = QueryFactory.deduplicate((DeduplicationStrategy)DeduplicationStrategy.MATERIALIZE);
        ResultSet results = this.indexedCollection.retrieve(this.query, QueryFactory.queryOptions((Object)deduplication));
        return new CQEngineVariantResultSetImpl((ResultSet<Map>)results, VCF_LINE_KEY);
    }

    class VariantTableHelper {
        private Map<String, Attribute<Map, ?>> tableColumnNameToAttributeMap = new HashMap();
        private boolean valuesCaseSensitive;
        private String sqlQuery;

        VariantTableHelper(String sqlQuery, boolean valuesCaseSensitive) {
            this.sqlQuery = sqlQuery;
            this.valuesCaseSensitive = valuesCaseSensitive;
        }

        void addTableColumn(String originalColumnName, AttributeType type) {
            Attribute attr = AttributeFactory.buildAttribute(originalColumnName, type);
            if (this.tableColumnNameToAttributeMap.containsKey(originalColumnName)) {
                String mesg = String.format("Found 2 columns with the same name: %s", originalColumnName);
                throw new RuntimeException(mesg);
            }
            this.tableColumnNameToAttributeMap.put(originalColumnName, attr);
        }

        Set<String> getMissingColumns() {
            HashSet<String> missingColumns = new HashSet<String>();
            for (String caseCorrectedQueryColumnName : this.getQueryColumnNames()) {
                if (this.tableColumnNameToAttributeMap.containsKey(caseCorrectedQueryColumnName)) continue;
                LOGGER.warn(String.format("Missing column %s", caseCorrectedQueryColumnName));
                missingColumns.add(caseCorrectedQueryColumnName);
            }
            return missingColumns;
        }

        Map<String, Attribute<Map, ?>> getTableColumnNameToAttributeMap() {
            return this.tableColumnNameToAttributeMap;
        }

        Query getQuery() {
            String sql = SqlPreProcessor.wildcardExpansion(this.sqlQuery, this.tableColumnNameToAttributeMap.keySet());
            return CQEngineUtil.buildQuery(sql, this.tableColumnNameToAttributeMap, this.valuesCaseSensitive);
        }

        Set<String> getQueryColumnNames() {
            String sql = SqlPreProcessor.wildcardExpansion(this.sqlQuery, this.tableColumnNameToAttributeMap.keySet());
            return CQEngineUtil.parseAttributeNames(sql);
        }

        IndexableObject caseCorrectObject(IndexableObject indexableObject) {
            if (this.valuesCaseSensitive) {
                return indexableObject;
            }
            IndexableObject transformedObject = new IndexableObject();
            Set objAttrNames = indexableObject.keySet();
            for (String objAttrName : objAttrNames) {
                Object value;
                Attribute<Map, ?> attr = this.tableColumnNameToAttributeMap.get(objAttrName);
                Object finalValue = value = indexableObject.get(objAttrName);
                if (attr.getAttributeType().equals(String.class) && !this.valuesCaseSensitive) {
                    if (value instanceof String) {
                        finalValue = CQEngineUtil.getCaseInsensitiveValue((String)value);
                    } else {
                        List list = (List)value;
                        ArrayList<String> caseInsensitiveList = new ArrayList<String>();
                        for (String s : list) {
                            caseInsensitiveList.add(CQEngineUtil.getCaseInsensitiveValue(s));
                        }
                        finalValue = caseInsensitiveList;
                    }
                }
                transformedObject.put(objAttrName, finalValue);
            }
            return transformedObject;
        }
    }
}

