/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.extract;

import edu.mayo.genomicutils.util.StringUtil;
import edu.mayo.genomicutils.vcf.VCFUtils;
import edu.mayo.genomicutils.vcf.extract.VCFExtractor;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DedicatedColumnVCFExtractorImpl
implements VCFExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DedicatedColumnVCFExtractorImpl.class);
    private static final String TAB = "\t";
    private static final Set<String> FIXED_FIELDS = new HashSet<String>(Arrays.asList("CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER"));
    private static final int COLUMN_FIXED_FIELD_CHROM = 0;
    private static final int COLUMN_FIXED_FIELD_POS = 1;
    private static final int COLUMN_FIXED_FIELD_ID = 2;
    private static final int COLUMN_FIXED_FIELD_REF = 3;
    private static final int COLUMN_FIXED_FIELD_ALT = 4;
    private static final int COLUMN_FIXED_FIELD_QUAL = 5;
    private static final int COLUMN_FIXED_FIELD_FILTER = 6;
    private List<String> fields;
    private char colDelimiter;
    private char valueDelimiter;

    public DedicatedColumnVCFExtractorImpl(List<String> fields, char colDelimiter, char valueDelimiter) throws Exception {
        this.fields = fields;
        this.colDelimiter = colDelimiter;
        this.valueDelimiter = valueDelimiter;
        if (fields.size() == 0) {
            throw new Exception("At least 1 field is required.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extract(File vcf, Writer outWriter) throws Exception {
        PrintWriter pWtr = new PrintWriter(outWriter);
        BufferedReader br = VCFUtils.open(vcf);
        boolean requireIndex = false;
        boolean strickWhitespaceChecking = false;
        VCFFileReader vcfFileReader = new VCFFileReader(vcf, false, false);
        VCFHeader vcfHeader = vcfFileReader.getFileHeader();
        ArrayList<String> infoFields = new ArrayList<String>();
        for (VCFInfoHeaderLine infoLine : vcfHeader.getInfoHeaderLines()) {
            infoFields.add(infoLine.getID());
        }
        ArrayList<String> allFields = new ArrayList<String>();
        allFields.addAll(FIXED_FIELDS);
        allFields.addAll(infoFields);
        this.fields = StringUtil.expand(this.fields, allFields, false);
        List<String> invalidFields = this.validateFields(vcf, infoFields);
        this.writeHeader(vcfHeader, pWtr, invalidFields);
        try {
            String line = this.skipPastHeader(br);
            for (VariantContext variant : vcfFileReader) {
                this.extractVariant(this.parseFixedFields(line), variant, pWtr, invalidFields);
                line = br.readLine();
            }
        }
        finally {
            pWtr.flush();
            IOUtils.closeQuietly((Reader)br);
            IOUtils.closeQuietly((Closeable)vcfFileReader);
            IOUtils.closeQuietly((Writer)pWtr);
        }
    }

    private String skipPastHeader(BufferedReader br) throws IOException {
        String line = br.readLine();
        while (line != null && line.startsWith("#")) {
            line = br.readLine();
        }
        return line;
    }

    private String[] parseFixedFields(String line) {
        String[] fixedFields = new String[7];
        String[] fields = line.split(TAB, -1);
        System.arraycopy(fields, 0, fixedFields, 0, fixedFields.length);
        return fixedFields;
    }

    private List<String> validateFields(File vcf, List<String> infoFields) {
        ArrayList<String> invalidFields = new ArrayList<String>();
        for (String field : this.fields) {
            if (FIXED_FIELDS.contains(field) || infoFields.contains(field)) continue;
            LOGGER.warn(String.format("Invalid field %s.  Not a fixed or info field in file %s", field, vcf.getAbsolutePath()));
            invalidFields.add(field);
        }
        return invalidFields;
    }

    private void writeHeader(VCFHeader vcfHeader, PrintWriter wtr, List<String> invalidFields) {
        StringBuilder colHeaderLine = new StringBuilder();
        colHeaderLine.append('#');
        for (String field : this.fields) {
            colHeaderLine.append(field);
            colHeaderLine.append(this.colDelimiter);
            if (FIXED_FIELDS.contains(field)) {
                wtr.print(String.format("## %s: A VCF fixed field.", field));
            } else if (invalidFields.contains(field)) {
                wtr.print(String.format("## %s: WARNING - field not found", field));
            } else {
                VCFInfoHeaderLine infoLine = vcfHeader.getInfoHeaderLine(field);
                wtr.print(String.format("## %s: %s", field, infoLine.getDescription()));
            }
            wtr.println();
        }
        colHeaderLine.deleteCharAt(colHeaderLine.length() - 1);
        wtr.println(colHeaderLine.toString());
    }

    private void extractVariant(String[] fixedFields, VariantContext variant, PrintWriter wtr, List<String> invalidFields) {
        int fieldCount = 0;
        for (String field : this.fields) {
            ++fieldCount;
            if (FIXED_FIELDS.contains(field)) {
                wtr.print(this.getFixedFieldValue(field, fixedFields));
            } else if (!invalidFields.contains(field)) {
                wtr.print(this.getInfoFieldValue(field, variant, this.valueDelimiter));
            }
            if (fieldCount == this.fields.size()) continue;
            wtr.print(this.colDelimiter);
        }
        wtr.println();
    }

    private String getFixedFieldValue(String field, String[] fixedFields) {
        if (field.equalsIgnoreCase("CHROM")) {
            return fixedFields[0];
        }
        if (field.equalsIgnoreCase("POS")) {
            return fixedFields[1];
        }
        if (field.equalsIgnoreCase("ID")) {
            return fixedFields[2];
        }
        if (field.equalsIgnoreCase("REF")) {
            return fixedFields[3];
        }
        if (field.equalsIgnoreCase("ALT")) {
            return fixedFields[4];
        }
        if (field.equalsIgnoreCase("QUAL")) {
            return fixedFields[5];
        }
        if (field.equalsIgnoreCase("FILTER")) {
            return fixedFields[6];
        }
        throw new RuntimeException(String.format("Unsupported CORE field: %s", field));
    }

    private String getInfoFieldValue(String field, VariantContext variant, char valDelimiter) {
        if (variant.hasAttribute(field)) {
            Object attr = variant.getAttribute(field);
            if (attr instanceof List) {
                StringBuilder sb = new StringBuilder();
                for (Object val : (List)attr) {
                    sb.append(val);
                    sb.append(valDelimiter);
                }
                sb.deleteCharAt(sb.length() - 1);
                return VCFUtils.decodeInfoFieldValues(sb.toString());
            }
            return VCFUtils.decodeInfoFieldValues(String.valueOf(attr));
        }
        return "";
    }
}

