/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.compoundhet;

import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.navigable.NavigableIndex;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.resultset.ResultSet;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JsonOrgJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import edu.mayo.genomicutils.vcf.compoundhet.HgncDataSource;
import edu.mayo.genomicutils.vcf.compoundhet.HgncEntry;
import edu.mayo.genomicutils.vcf.compoundhet.HgncEntryNotFoundException;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryHgncDataSourceImpl
implements HgncDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryHgncDataSourceImpl.class);
    private static final String TAB = "\t";
    private static final Attribute<HgncEntry, String> ATTR_ENSEMBL_GENE_ID = new SimpleAttribute<HgncEntry, String>(){

        public String getValue(HgncEntry entry, QueryOptions queryOptions) {
            return entry.ensemblGeneID;
        }
    };
    private IndexedCollection<HgncEntry> hgncEntries = new ConcurrentIndexedCollection();
    private JsonProvider jsonProvider = new JsonOrgJsonProvider();
    private Configuration config = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider(this.jsonProvider).build();

    public InMemoryHgncDataSourceImpl(File catalogDataFile, JsonPath approvedSymbolPath, JsonPath ensemblGeneIdPath, JsonPath ncbiGeneIdPath, JsonPath hgncGeneIdPath) throws IOException {
        this.hgncEntries.addIndex((Index)NavigableIndex.onAttribute(ATTR_ENSEMBL_GENE_ID));
        this.load(catalogDataFile, approvedSymbolPath, ensemblGeneIdPath, ncbiGeneIdPath, hgncGeneIdPath);
    }

    private void load(File catalogDataFile, JsonPath approvedSymbolPath, JsonPath ensemblGeneIdPath, JsonPath ncbiGeneIdPath, JsonPath hgncGeneIdPath) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new BlockCompressedInputStream(catalogDataFile)));
        while ((line = br.readLine()) != null) {
            HgncEntry entry = new HgncEntry();
            String[] cols = line.split(TAB, -1);
            String json = cols[3];
            String approvedSymbolValue = (String)approvedSymbolPath.read(json, this.config);
            entry.approvedSymbol = approvedSymbolValue == null ? "." : approvedSymbolValue;
            String ensemblGeneIdValue = (String)ensemblGeneIdPath.read(json, this.config);
            entry.ensemblGeneID = ensemblGeneIdValue == null ? "." : ensemblGeneIdValue;
            String ncbiGeneIdValue = (String)ncbiGeneIdPath.read(json, this.config);
            entry.ncbiGeneID = ncbiGeneIdValue == null ? "." : ncbiGeneIdValue;
            String hgncGeneIdValue = (String)hgncGeneIdPath.read(json, this.config);
            entry.hgncId = hgncGeneIdValue == null ? "." : hgncGeneIdValue;
            this.hgncEntries.add((Object)entry);
        }
        LOGGER.info(String.format("Loaded %s rows from %s", this.hgncEntries.size(), catalogDataFile.getAbsolutePath()));
    }

    @Override
    public List<HgncEntry> findByEnsemblGeneID(String ensemblGeneID) throws HgncEntryNotFoundException {
        Equal overlapQuery = QueryFactory.equal(ATTR_ENSEMBL_GENE_ID, (Object)ensemblGeneID);
        ResultSet resultSet = this.hgncEntries.retrieve((Query)overlapQuery);
        ArrayList<HgncEntry> entries = new ArrayList<HgncEntry>();
        for (HgncEntry entry : resultSet) {
            entries.add(entry);
        }
        if (entries.size() == 0) {
            throw new HgncEntryNotFoundException(String.format("No HGNC entry found for Ensembl gene ID %s", ensemblGeneID));
        }
        return entries;
    }
}

