/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.vcf.compoundhet;

import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.navigable.NavigableIndex;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JsonOrgJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import edu.mayo.genomicutils.vcf.compoundhet.Gene;
import edu.mayo.genomicutils.vcf.compoundhet.GeneDataSource;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryGeneDataSourceImpl
implements GeneDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryGeneDataSourceImpl.class);
    private static final String TAB = "\t";
    private static final Attribute<Gene, String> ATTR_CHR = new SimpleAttribute<Gene, String>(){

        public String getValue(Gene g, QueryOptions queryOptions) {
            return g.chrom;
        }
    };
    private static final Attribute<Gene, Integer> ATTR_MINBP = new SimpleAttribute<Gene, Integer>(){

        public Integer getValue(Gene g, QueryOptions queryOptions) {
            return g.minBP;
        }
    };
    private static final Attribute<Gene, Integer> ATTR_MAXBP = new SimpleAttribute<Gene, Integer>(){

        public Integer getValue(Gene g, QueryOptions queryOptions) {
            return g.maxBP;
        }
    };
    private IndexedCollection<Gene> genes = new ConcurrentIndexedCollection();
    private JsonProvider jsonProvider = new JsonOrgJsonProvider();
    private Configuration config = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider(this.jsonProvider).build();

    public InMemoryGeneDataSourceImpl(File catalogDataFile, JsonPath geneIdPath) throws IOException {
        this.genes.addIndex((Index)NavigableIndex.onAttribute(ATTR_CHR));
        this.genes.addIndex((Index)NavigableIndex.onAttribute(ATTR_MINBP));
        this.genes.addIndex((Index)NavigableIndex.onAttribute(ATTR_MAXBP));
        this.loadGenes(catalogDataFile, geneIdPath);
    }

    private void loadGenes(File catalogDataFile, JsonPath geneIdPath) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new BlockCompressedInputStream(catalogDataFile)));
        while ((line = br.readLine()) != null) {
            Gene gene = new Gene();
            String[] cols = line.split(TAB, -1);
            gene.chrom = cols[0];
            gene.minBP = Integer.parseInt(cols[1]);
            gene.maxBP = Integer.parseInt(cols[2]);
            String json = cols[3];
            Object value = geneIdPath.read(json, this.config);
            gene.id = value == null ? "." : (String)value;
            this.genes.add((Object)gene);
        }
        LOGGER.info(String.format("Loaded %s genes from %s", this.genes.size(), catalogDataFile.getAbsolutePath()));
    }

    @Override
    public List<Gene> findGenes(String chr, int minBP, int maxBP) {
        And overlapQuery = QueryFactory.and((Query)QueryFactory.equal(ATTR_CHR, (Object)chr), (Query)QueryFactory.lessThanOrEqualTo(ATTR_MINBP, (Comparable)Integer.valueOf(minBP)), (Query)QueryFactory.greaterThanOrEqualTo(ATTR_MAXBP, (Comparable)Integer.valueOf(maxBP)));
        ArrayList<Gene> hits = new ArrayList<Gene>();
        for (Gene gene : this.genes.retrieve((Query)overlapQuery)) {
            hits.add(gene);
        }
        return hits;
    }
}

