/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.impl;

import java.util.Iterator;
import java.util.Set;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.GeneticAlgorithm;
import org.biojavax.ga.Organism;
import org.biojavax.ga.Population;
import org.biojavax.ga.exception.IllegalOrganismException;

public abstract class AbstractPopulation
extends AbstractChangeable
implements Population {
    String name;

    public AbstractPopulation() {
        this("");
    }

    public AbstractPopulation(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setName(String name) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.name = name;
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, Population.NAME, name, this.name);
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(GeneticAlgorithm.POPULATION);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.name = name;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addOrganism(Organism org) throws ChangeVetoException, IllegalOrganismException {
        if (!this.hasListeners()) {
            this.addOrganismImpl(org);
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, Population.ORGANISMS, org, this.getOrganisms());
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(GeneticAlgorithm.POPULATION);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.addOrganismImpl(org);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    protected abstract void addOrganismImpl(Organism var1) throws IllegalOrganismException;

    @Override
    public final void addOrganisms(Organism[] orgs) throws ChangeVetoException, IllegalOrganismException {
        for (int i = 0; i < orgs.length; ++i) {
            this.addOrganism(orgs[i]);
        }
    }

    @Override
    public final void addOrganisms(Set orgs) throws ChangeVetoException, IllegalOrganismException {
        for (Object o : orgs) {
            if (o instanceof Organism) {
                this.addOrganism((Organism)o);
                continue;
            }
            throw new IllegalOrganismException("Attempting to add a non Organism object to a population, object is: " + o.getClass().getName());
        }
    }

    @Override
    public final void addOrganisms(Population orgs) throws ChangeVetoException, IllegalOrganismException {
        Iterator i = orgs.organisms();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof Organism) {
                this.addOrganism((Organism)o);
                continue;
            }
            throw new IllegalOrganismException("Attempting to add a non Organism object to a population, object is: " + o.getClass().getName());
        }
    }

    @Override
    public final void removeOrganisms(Organism[] orgs) throws ChangeVetoException {
        for (int i = 0; i < orgs.length; ++i) {
            this.removeOrganismImpl(orgs[i]);
        }
    }

    @Override
    public final void removeOrganisms(Set orgs) throws ChangeVetoException {
        Iterator i = orgs.iterator();
        while (i.hasNext()) {
            this.removeOrganismImpl((Organism)i.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeAllOrganisms() throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.removeAllOrganismsImpl();
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, Population.ORGANISMS, null, this.getOrganisms());
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(GeneticAlgorithm.POPULATION);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.removeAllOrganismsImpl();
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeOrganism(Organism org) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.removeOrganismImpl(org);
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, Population.ORGANISMS, org, this.getOrganisms());
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(GeneticAlgorithm.POPULATION);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.removeOrganismImpl(org);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    protected abstract void removeOrganismImpl(Organism var1);

    protected abstract void removeAllOrganismsImpl();
}

