/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import java.util.Random;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.functions.AbstractMutationFunction;

public class SwapMutationFunction
extends AbstractMutationFunction {
    public SwapMutationFunction(double[] probabilities) {
        this.setMutationProbs(probabilities);
        this.setMutationSpectrum(null);
    }

    @Override
    public SymbolList mutate(SymbolList seq) throws IllegalAlphabetException, ChangeVetoException, IllegalSymbolException {
        int[] pos = this.generateMutationPositions(seq.length());
        if (pos[0] == pos[1] || (double)pos[0] == 0.0) {
            return seq;
        }
        Edit ed1 = new Edit(pos[0], seq.getAlphabet(), seq.symbolAt(pos[1]));
        Edit ed2 = new Edit(pos[1], seq.getAlphabet(), seq.symbolAt(pos[0]));
        seq.edit(ed1);
        seq.edit(ed2);
        return seq;
    }

    private int[] generateMutationPositions(int seqLength) {
        Random n = new Random();
        int[] positions = new int[2];
        double[] tempprobs = new double[seqLength];
        int maxIndex = this.getMutationProbs().length - 1;
        for (int i = 1; i <= seqLength; ++i) {
            int index = Math.min(i - 1, maxIndex);
            double mutProb = this.getMutationProbs()[index] - n.nextDouble();
            tempprobs[i - 1] = mutProb >= 0.0 ? mutProb : 0.0;
        }
        double highest = 0.0;
        double second = 0.0;
        for (int j = 0; j < tempprobs.length; ++j) {
            double current = tempprobs[j];
            if (!(current > second)) continue;
            if (current > highest) {
                positions[0] = positions[1];
                second = highest;
                positions[1] = j + 1;
                highest = current;
                continue;
            }
            second = current;
            positions[0] = j + 1;
        }
        if (positions[0] > positions[1]) {
            int temp = positions[0];
            positions[0] = positions[1];
            positions[1] = temp;
        }
        return positions;
    }
}

