/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import java.util.Random;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.functions.AbstractMutationFunction;

public final class SimpleMutationFunction
extends AbstractMutationFunction {
    @Override
    public SymbolList mutate(SymbolList seq) throws ChangeVetoException, IllegalAlphabetException, IllegalSymbolException {
        int maxIndex = this.getMutationProbs().length - 1;
        OrderNDistribution d = this.getMutationSpectrum();
        Random r = new Random();
        for (int i = 1; i < seq.length(); ++i) {
            int index = Math.min(i - 1, maxIndex);
            double mutProb = this.getMutationProbs()[index];
            if (!(r.nextDouble() < mutProb)) continue;
            Edit e = new Edit(i, seq.getAlphabet(), d.getDistribution(seq.symbolAt(i)).sampleSymbol());
            seq.edit(e);
        }
        return seq;
    }
}

