/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public interface MutationFunction
extends Changeable {
    public static final double[] DEFAULT_MUTATION_PROBS = new double[]{0.0};
    public static final ChangeType MUTATION_PROBS = new ChangeType("mutation probabilities", MutationFunction.class, "MUTATION_PROBS");
    public static final ChangeType MUTATION_SPECTRUM = new ChangeType("mutation spectrum", MutationFunction.class, "MUTATION_SPECTRUM");
    public static final MutationFunction NO_MUTATION = new NoMutation();

    public SymbolList mutate(SymbolList var1) throws IllegalAlphabetException, ChangeVetoException, IllegalSymbolException;

    public void setMutationProbs(double[] var1) throws ChangeVetoException;

    public double[] getMutationProbs();

    public void setMutationSpectrum(OrderNDistribution var1) throws ChangeVetoException;

    public OrderNDistribution getMutationSpectrum();

    public static final class NoMutation
    implements MutationFunction {
        @Override
        public double[] getMutationProbs() {
            return DEFAULT_MUTATION_PROBS;
        }

        @Override
        public OrderNDistribution getMutationSpectrum() {
            return null;
        }

        @Override
        public SymbolList mutate(SymbolList syml) {
            return syml;
        }

        @Override
        public void setMutationProbs(double[] muts) throws ChangeVetoException {
            throw new ChangeVetoException("Cannot setMutationProbs for a NoMutation function");
        }

        @Override
        public void setMutationSpectrum(OrderNDistribution odn) throws ChangeVetoException {
            throw new ChangeVetoException("Cannot set a Mutation spectrum for a NoMutation function");
        }

        @Override
        public boolean isUnchanging(ChangeType ct) {
            return true;
        }

        @Override
        public void removeChangeListener(ChangeListener c) {
        }

        @Override
        public void addChangeListener(ChangeListener cl) {
        }

        @Override
        public void addChangeListener(ChangeListener cl, ChangeType ct) {
        }

        @Override
        public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        }
    }
}

