/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.io.ChunkedSymbolListFactory;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SimpleSymbolListFactory;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListFactory;
import org.biojava.ontology.InvalidTermException;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.Comment;
import org.biojavax.Namespace;
import org.biojavax.RankedCrossRef;
import org.biojavax.RankedDocRef;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleComment;
import org.biojavax.SimpleNote;
import org.biojavax.SimpleRichAnnotation;
import org.biojavax.bio.BioEntryRelationship;
import org.biojavax.bio.seq.EmptyRichLocation;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.SimpleRichFeature;
import org.biojavax.bio.seq.SimpleRichFeatureRelationship;
import org.biojavax.bio.seq.SimpleRichSequence;
import org.biojavax.bio.seq.io.RichSeqIOAdapter;
import org.biojavax.bio.seq.io.RichSequenceBuilder;
import org.biojavax.bio.taxa.NCBITaxon;
import org.biojavax.ontology.ComparableTerm;

public class SimpleRichSequenceBuilder
extends RichSeqIOAdapter
implements RichSequenceBuilder {
    private RichAnnotation notes = new SimpleRichAnnotation();
    private int version;
    private boolean versionSeen;
    private double seqVersion = 0.0;
    private boolean seqVersionSeen;
    private String accession;
    private String description;
    private String division;
    private String identifier;
    private String name;
    private Set<RankedCrossRef> crossRefs = new TreeSet<RankedCrossRef>();
    private int crossRefsRank = 1;
    private SymbolListFactory factory;
    private int threshold;
    private ChunkedSymbolListFactory symbols;
    private Set<Comment> comments = new TreeSet<Comment>();
    private int commentRank = 1;
    private Namespace namespace;
    private FeatureHolder featureHolder = new SimpleFeatureHolder();
    private Set rootFeatures = new TreeSet();
    private List allFeatures = new ArrayList();
    private List featureStack = new ArrayList();
    private int featureRank = 1;
    private NCBITaxon taxon;
    private Set<BioEntryRelationship> relations = new TreeSet<BioEntryRelationship>();
    private Set<RankedDocRef> references = new TreeSet<RankedDocRef>();
    private int referenceCount = 1;
    int featPropCount = 1;
    int seqPropCount = 1;
    private boolean circular = false;

    public SimpleRichSequenceBuilder() {
        this(new SimpleSymbolListFactory(), 0);
    }

    public SimpleRichSequenceBuilder(SymbolListFactory factory) {
        this(factory, 0);
    }

    public SimpleRichSequenceBuilder(SymbolListFactory factory, int threshold) {
        this.reset();
        this.factory = factory;
        this.threshold = threshold;
    }

    private void reset() {
        try {
            this.version = 0;
            this.versionSeen = false;
            this.seqVersion = 0.0;
            this.seqVersionSeen = false;
            this.accession = null;
            this.description = null;
            this.division = null;
            this.identifier = null;
            this.name = null;
            this.crossRefs.clear();
            this.symbols = null;
            this.namespace = null;
            this.taxon = null;
            this.seqPropCount = 1;
            this.referenceCount = 1;
            this.commentRank = 1;
            this.featureRank = 1;
            this.featPropCount = 1;
            this.comments.clear();
            this.relations.clear();
            this.references.clear();
            this.rootFeatures.clear();
            this.featureStack.clear();
            this.allFeatures.clear();
            this.notes.clear();
        }
        catch (ChangeVetoException ex) {
            throw new BioError("A ChangeListener should not have been applied", ex);
        }
    }

    @Override
    public void setVersion(int version) throws ParseException {
        if (this.versionSeen) {
            throw new ParseException("Current BioEntry already has a version");
        }
        try {
            this.version = version;
            this.versionSeen = true;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Could not parse version as an integer");
        }
    }

    @Override
    public void setURI(String uri) throws ParseException {
        throw new ParseException("We don't understand URIs");
    }

    @Override
    public void setSeqVersion(String seqVersion) throws ParseException {
        if (this.seqVersionSeen) {
            throw new ParseException("Current BioEntry already has a sequence version");
        }
        if (seqVersion == null) {
            this.seqVersion = 0.0;
        } else {
            try {
                this.seqVersion = Double.parseDouble(seqVersion);
                this.seqVersionSeen = true;
            }
            catch (NumberFormatException e) {
                throw new ParseException("Could not parse sequence version as a double");
            }
        }
    }

    @Override
    public void setAccession(String accession) throws ParseException {
        if (accession == null) {
            throw new ParseException("Accession cannot be null");
        }
        this.accession = accession;
    }

    @Override
    public void setDescription(String description) throws ParseException {
        if (this.description != null) {
            throw new ParseException("Current BioEntry already has a description");
        }
        this.description = description;
    }

    @Override
    public void setDivision(String division) throws ParseException {
        if (division == null) {
            throw new ParseException("Division cannot be null");
        }
        if (this.division != null) {
            throw new ParseException("Current BioEntry already has a division");
        }
        this.division = division;
    }

    @Override
    public void setIdentifier(String identifier) throws ParseException {
        if (identifier == null) {
            throw new ParseException("Identifier cannot be null");
        }
        if (this.identifier != null) {
            throw new ParseException("Current BioEntry already has a identifier");
        }
        this.identifier = identifier;
    }

    @Override
    public void setName(String name) throws ParseException {
        if (name == null) {
            throw new ParseException("Name cannot be null");
        }
        if (this.name != null) {
            throw new ParseException("Current BioEntry already has a name");
        }
        this.name = name;
    }

    @Override
    public void setRankedCrossRef(RankedCrossRef ref) throws ParseException {
        if (ref == null) {
            throw new ParseException("Reference cannot be null");
        }
        ref.setRank(this.crossRefsRank++);
        this.crossRefs.add(ref);
    }

    @Override
    public void addSymbols(Alphabet alpha, Symbol[] syms, int start, int length) throws IllegalAlphabetException {
        if (this.symbols == null) {
            this.symbols = this.threshold <= 0 ? new ChunkedSymbolListFactory(this.factory) : new ChunkedSymbolListFactory(this.factory, this.threshold);
        }
        this.symbols.addSymbols(alpha, syms, start, length);
    }

    @Override
    public void setComment(String comment) throws ParseException {
        if (comment == null) {
            throw new ParseException("Comment cannot be null");
        }
        this.comments.add(new SimpleComment(comment, this.commentRank++));
    }

    @Override
    public void setNamespace(Namespace namespace) throws ParseException {
        if (namespace == null) {
            throw new ParseException("Namespace cannot be null");
        }
        if (this.namespace != null) {
            throw new ParseException("Current BioEntry already has a namespace");
        }
        this.namespace = namespace;
    }

    @Override
    public void startFeature(Feature.Template templ) throws ParseException {
        try {
            SimpleRichFeature f = new SimpleRichFeature(this.featureHolder, templ);
            f.setRank(this.featureRank++);
            this.allFeatures.add(f);
            if (this.featureStack.size() == 0) {
                this.rootFeatures.add(f);
            } else {
                RichFeature parent = (RichFeature)this.featureStack.get(this.featureStack.size() - 1);
                parent.addFeatureRelationship(new SimpleRichFeatureRelationship(parent, f, SimpleRichFeatureRelationship.getContainsTerm(), 0));
            }
            this.featPropCount = 1;
            this.featureStack.add(f);
        }
        catch (ChangeVetoException e) {
            throw new ParseException(e);
        }
        catch (InvalidTermException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public RichFeature getCurrentFeature() throws ParseException {
        if (this.featureStack.size() == 0) {
            throw new ParseException("Not currently within a feature");
        }
        return (RichFeature)this.featureStack.get(this.featureStack.size() - 1);
    }

    @Override
    public void setTaxon(NCBITaxon taxon) throws ParseException {
        if (taxon == null) {
            throw new ParseException("Taxon cannot be null");
        }
        if (this.taxon != null && !this.taxon.equals(taxon)) {
            System.err.println("Warning: attempted to set taxon twice with different values. Keeping first value. old value (retained): " + this.taxon + " new value: " + taxon + ", accession: <" + this.accession + ">, version:" + this.version);
        }
        this.taxon = taxon;
    }

    @Override
    public void setRelationship(BioEntryRelationship relationship) throws ParseException {
        if (relationship == null) {
            throw new ParseException("Relationship cannot be null");
        }
        this.relations.add(relationship);
    }

    @Override
    public void setRankedDocRef(RankedDocRef ref) throws ParseException {
        if (ref == null) {
            throw new ParseException("Reference cannot be null");
        }
        ref.setRank(this.referenceCount++);
        this.references.add(ref);
    }

    @Override
    public void startSequence() throws ParseException {
        this.reset();
    }

    @Override
    public void addFeatureProperty(Object key, Object value) throws ParseException {
        if (this.featureStack.size() == 0) {
            throw new ParseException("Assertion failed: Not within a feature");
        }
        if (!(key instanceof ComparableTerm)) {
            key = RichObjectFactory.getDefaultOntology().getOrCreateTerm(key.toString());
        }
        if (value != null && !(value instanceof String)) {
            value = value.toString();
        }
        RichFeature f = this.getCurrentFeature();
        try {
            SimpleNote n = new SimpleNote((ComparableTerm)key, (String)value, this.featPropCount++);
            f.getRichAnnotation().addNote(n);
        }
        catch (ChangeVetoException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void addSequenceProperty(Object key, Object value) throws ParseException {
        if (!(key instanceof ComparableTerm)) {
            key = RichObjectFactory.getDefaultOntology().getOrCreateTerm(key.toString());
        }
        if (value != null && !(value instanceof String)) {
            value = value.toString();
        }
        try {
            SimpleNote n = value == null ? new SimpleNote((ComparableTerm)key, null, this.seqPropCount++) : new SimpleNote((ComparableTerm)key, (String)value, this.seqPropCount++);
            this.notes.addNote(n);
        }
        catch (ChangeVetoException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void endFeature() throws ParseException {
        if (this.featureStack.size() == 0) {
            throw new ParseException("Assertion failed: Not within a feature");
        }
        this.featureStack.remove(this.featureStack.size() - 1);
    }

    @Override
    public void endSequence() throws ParseException {
        if (this.name == null) {
            throw new ParseException("Name has not been supplied");
        }
        if (this.namespace == null) {
            throw new ParseException("Namespace has not been supplied");
        }
        if (this.accession == null) {
            throw new ParseException("No accessions have been supplied");
        }
    }

    @Override
    public void setCircular(boolean circular) throws ParseException {
        this.circular = circular;
    }

    @Override
    public Sequence makeSequence() throws BioException {
        this.endSequence();
        SymbolList syms = this.symbols == null ? SymbolList.EMPTY_LIST : this.symbols.makeSymbolList();
        SimpleRichSequence rs = new SimpleRichSequence(this.namespace, this.name, this.accession, this.version, syms, new Double(this.seqVersion));
        try {
            for (RichFeature f : this.allFeatures) {
                f.setParent(rs);
                if (f.getName() != null && f.getName().length() != 0) continue;
                f.setName(rs.getAccession() + "#" + f.getRank());
            }
            rs.setDescription(this.description);
            rs.setDivision(this.division);
            rs.setIdentifier(this.identifier);
            rs.setTaxon(this.taxon);
            rs.setCircular(this.circular);
            if (this.circular && this.symbols != null) {
                int circularlength = syms.length();
                for (Object obj : this.rootFeatures) {
                    Feature rf = (Feature)obj;
                    RichLocation rlc = RichLocation.Tools.enrich(rf.getLocation());
                    rlc.setCircularLength(circularlength);
                }
            }
            rs.setFeatureSet(this.rootFeatures);
            Iterator<Object> i = this.crossRefs.iterator();
            while (i.hasNext()) {
                rs.addRankedCrossRef((RankedCrossRef)i.next());
            }
            i = this.relations.iterator();
            while (i.hasNext()) {
                rs.addRelationship((BioEntryRelationship)i.next());
            }
            if (this.circular && this.symbols != null) {
                int circularlength = syms.length();
                for (RankedDocRef rdf : this.references) {
                    RichLocation rlc = RichLocation.Tools.enrich(rdf.getLocation());
                    if (rlc instanceof EmptyRichLocation) continue;
                    rlc.setCircularLength(circularlength);
                }
            }
            Iterator<Comparable> i2 = this.references.iterator();
            while (i2.hasNext()) {
                rs.addRankedDocRef(i2.next());
            }
            i2 = this.comments.iterator();
            while (i2.hasNext()) {
                rs.addComment((Comment)i2.next());
            }
            rs.setNoteSet(this.notes.getNoteSet());
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
        return rs;
    }

    @Override
    public RichSequence makeRichSequence() throws BioException {
        return (RichSequence)this.makeSequence();
    }
}

