/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.alignment.blast;

import java.util.HashMap;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojavax.bio.alignment.RemotePairwiseAlignmentOutputProperties;
import org.biojavax.bio.alignment.blast.RemoteQBlastOutputFormat;

public class RemoteQBlastOutputProperties
implements RemotePairwiseAlignmentOutputProperties {
    private static final long serialVersionUID = 1L;
    private HashMap<String, String> out = new HashMap();
    private String outFormat = "FORMAT_TYPE=Text";
    private String alignFormat = "ALIGNMENT_VIEW=Pairwise";
    private int descNumbers = 100;
    private int alignNumbers = 100;

    public RemoteQBlastOutputProperties() {
        this.out.put("FORMAT_TYPE", this.outFormat);
        this.out.put("ALIGNMENT_VIEW", this.alignFormat);
        this.out.put("DESCRIPTIONS", "DESCRIPTIONS=" + this.descNumbers);
        this.out.put("ALIGNMENTS", "ALIGNMENTS=" + this.alignNumbers);
    }

    public String getOutputFormat() {
        return this.out.get("FORMAT_TYPE");
    }

    public void setOutputFormat(RemoteQBlastOutputFormat rf) throws BioException {
        switch (rf) {
            case TEXT: {
                this.outFormat = "FORMAT_TYPE=Text";
                this.out.put("FORMAT_TYPE", this.outFormat);
                break;
            }
            case XML: {
                this.outFormat = "FORMAT_TYPE=XML";
                this.out.put("FORMAT_TYPE", this.outFormat);
                break;
            }
            case HTML: {
                this.outFormat = "FORMAT_TYPE=HTML";
                this.out.put("FORMAT_TYPE", this.outFormat);
                break;
            }
            default: {
                throw new BioException("Unacceptable selection of format type. Only values text / XML / HTML accepted");
            }
        }
    }

    public String getAlignmentOutputFormat() {
        return this.out.get("ALIGNMENT_VIEW");
    }

    public void setAlignmentOutputFormat(RemoteQBlastOutputFormat rf) throws BioException {
        switch (rf) {
            case PAIRWISE: {
                this.alignFormat = "ALIGNMENT_VIEW=Pairwise";
                this.out.put("ALIGNMENT_VIEW", this.alignFormat);
                break;
            }
            case QUERY_ANCHORED: {
                this.alignFormat = "ALIGNMENT_VIEW=QueryAnchored";
                this.out.put("ALIGNMENT_VIEW", this.alignFormat);
                break;
            }
            case QUERY_ANCHORED_NO_IDENTITIES: {
                this.alignFormat = "ALIGNMENT_VIEW=QueryAnchoredNoIdentities";
                this.out.put("ALIGNMENT_VIEW", this.alignFormat);
                break;
            }
            case FLAT_QUERY_ANCHORED: {
                this.alignFormat = "ALIGNMENT_VIEW=FlatQueryAnchored";
                this.out.put("ALIGNMENT_VIEW", this.alignFormat);
                break;
            }
            case FLAT_QUERY_ANCHORED_NO_IDENTITIES: {
                this.alignFormat = "ALIGNMENT_VIEW=FlatQueryAnchoredNoIdentities";
                this.out.put("ALIGNMENT_VIEW", this.alignFormat);
                break;
            }
            case TABULAR: {
                this.alignFormat = "ALIGNMENT_VIEW=Tabular";
                this.out.put("ALIGNMENT_VIEW", this.alignFormat);
                break;
            }
            default: {
                throw new BioException("Unacceptable selection of alignment type. Only values Pairwise / QueryAnchored / QueryAnchoredNoIdentities / FlatQueryAnchored / FlatQueryAnchoredNoIdentities / Tabular accepted");
            }
        }
    }

    public int getDescriptionNumber() {
        String val = this.out.get("DESCRIPTIONS");
        String[] vals = val.split("=");
        int i = Integer.parseInt(vals[1]);
        return i;
    }

    public void setDescriptionNumber(int i) {
        this.descNumbers = i;
        this.out.put("DESCRIPTIONS", "DESCRIPTIONS=" + this.descNumbers);
    }

    public int getAlignmentNumber() {
        String val = this.out.get("ALIGNMENTS");
        String[] vals = val.split("=");
        int i = Integer.parseInt(vals[1]);
        return i;
    }

    public void setAlignmentNumber(int i) {
        this.alignNumbers = i;
        this.out.put("ALIGNMENTS", "ALIGNMENTS=" + this.alignNumbers);
    }

    @Override
    public String getOutputOption(String o) throws BioException {
        if (this.out.containsKey(o)) {
            return this.out.get(o);
        }
        throw new BioException("The key named " + o + " is not set in this RemoteQBlastOutputProperties object");
    }

    @Override
    public void setOutputOption(String o, String v) {
        this.out.put(o, v);
    }

    @Override
    public Set<String> getOutputOptions() {
        return this.out.keySet();
    }
}

