/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.biojava.utils.ClassTools;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResourceEntityResolver
implements EntityResolver {
    private String[] path;
    private ClassLoader classLoader;

    private String[] parsePath(String path) {
        ArrayList<String> pathElements = new ArrayList<String>();
        StringTokenizer toke = new StringTokenizer(path, ":");
        while (toke.hasMoreTokens()) {
            pathElements.add(toke.nextToken());
        }
        return pathElements.toArray(new String[0]);
    }

    public ResourceEntityResolver(String path) {
        this.path = this.parsePath(path);
        this.classLoader = ClassTools.getClassLoader(this);
    }

    public ResourceEntityResolver(String[] path) {
        this.path = path;
        this.classLoader = ClassTools.getClassLoader(this);
    }

    public ResourceEntityResolver(String[] path, ClassLoader classLoader) {
        this.path = path;
        this.classLoader = classLoader;
    }

    public ResourceEntityResolver(String path, ClassLoader classLoader) {
        this.path = this.parsePath(path);
        this.classLoader = classLoader;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        int index = systemId.lastIndexOf(47);
        if (index >= 0) {
            systemId = systemId.substring(index + 1);
        }
        for (int i = 0; i < this.path.length; ++i) {
            InputStream is = this.classLoader.getResourceAsStream(this.path[i] + "/" + systemId);
            if (is == null) continue;
            InputSource source = new InputSource(is);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        return null;
    }
}

