/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.process;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReaderWriterPipe
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ReaderWriterPipe.class.getName());
    private Reader reader;
    private Writer writer;
    private String tag;

    public ReaderWriterPipe(Reader reader, Writer writer, String tag) {
        this.setReader(reader);
        this.setWriter(writer);
        this.tag = tag;
    }

    public Reader getReader() {
        return this.reader;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void run() {
        LOGGER.entering(this.getClass().getName(), "run");
        if (this.reader != null) {
            try {
                BufferedWriter bout = null;
                if (this.writer != null) {
                    bout = new BufferedWriter(this.writer);
                }
                BufferedReader bin = new BufferedReader(this.reader);
                boolean log = LOGGER.isLoggable(Level.FINEST);
                String line = null;
                while ((line = bin.readLine()) != null) {
                    if (bout == null) continue;
                    if (log) {
                        if (this.tag == null) {
                            LOGGER.finest(line);
                        } else {
                            LOGGER.finest("<" + this.tag + "> " + line);
                        }
                    }
                    bout.write(line);
                    bout.newLine();
                    bout.flush();
                }
            }
            catch (Exception e) {
                LOGGER.severe(e.toString());
            }
        }
        LOGGER.exiting(this.getClass().getName(), "run");
    }
}

