/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.StringTokenizer;
import org.biojava.utils.ProcessTimeoutException;

public class ProcessTools {
    private static final String WINDOWS_NT_2000_COMMAND_1 = "cmd.exe";
    private static final String WINDOWS_NT_2000_COMMAND_2 = "/C";
    private static final String WINDOWS_9X_ME_COMMAND_1 = "command.exe";
    private static final String WINDOWS_9X_ME_COMMAND_2 = "/C";

    private ProcessTools() {
    }

    public static int exec(String[] args, Reader input, Writer stdout, Writer stderr) throws IOException {
        try {
            return ProcessTools.exec(args, null, null, input, stdout, stderr, 0L);
        }
        catch (ProcessTimeoutException ex) {
            throw new Error("Assertion failed: unexpected process timeout");
        }
    }

    public static int exec(String[] args, String[] envp, File dir, Reader input, Writer stdout, Writer stderr, long timeout) throws IOException, ProcessTimeoutException {
        int rc;
        Process proc = Runtime.getRuntime().exec(args, envp, dir);
        if (input == null) {
            input = new StringReader("");
        }
        PumpReaderToWriter outPump = new PumpReaderToWriter(input, new OutputStreamWriter(proc.getOutputStream()));
        CharPump inPump = stdout == null ? new PumpReaderToNull(new InputStreamReader(proc.getInputStream())) : new PumpReaderToWriter(new InputStreamReader(proc.getInputStream()), stdout);
        CharPump errPump = stderr == null ? new PumpReaderToNull(new InputStreamReader(proc.getErrorStream())) : new PumpReaderToWriter(new InputStreamReader(proc.getErrorStream()), stderr);
        TimeBomb tb = null;
        if (timeout > 0L) {
            tb = new TimeBomb(proc, timeout);
            tb.start();
        }
        outPump.start();
        inPump.start();
        errPump.start();
        try {
            rc = proc.waitFor();
            if (tb != null) {
                tb.defuse();
            }
            outPump.join();
            inPump.join();
            errPump.join();
        }
        catch (InterruptedException iex) {
            throw new IOException("Error waiting for process to complete");
        }
        if (tb != null && tb.fired()) {
            throw new ProcessTimeoutException(rc);
        }
        ProcessTools.checkException(outPump, "Output to child");
        ProcessTools.checkException(inPump, "Input from child");
        ProcessTools.checkException(errPump, "Errors from child");
        return rc;
    }

    public static int exec(String command, Reader input, Writer stdout, Writer stderr) throws IOException {
        try {
            return ProcessTools.exec(command, null, null, input, stdout, stderr, 0L);
        }
        catch (ProcessTimeoutException ex) {
            throw new Error("Assertion failed: unexpected process timeout");
        }
    }

    public static int exec(String command, String[] envp, File dir, Reader input, Writer stdout, Writer stderr, long timeout) throws IOException, ProcessTimeoutException {
        String[] cmd = null;
        String osName = System.getProperty("os.name");
        if (osName.equals("Windows NT") || osName.equals("Windows 2000") || osName.equals("Windows XP")) {
            cmd = new String[]{WINDOWS_NT_2000_COMMAND_1, "/C", command};
        } else if (osName.equals("Windows 95") || osName.equals("Windows 98") || osName.equalsIgnoreCase("Windows ME")) {
            cmd = new String[]{WINDOWS_9X_ME_COMMAND_1, "/C", command};
        } else {
            StringTokenizer st = new StringTokenizer(command, " ");
            cmd = new String[st.countTokens()];
            int token = 0;
            while (st.hasMoreTokens()) {
                String tokenString = st.nextToken();
                cmd[token++] = tokenString;
            }
        }
        return ProcessTools.exec(cmd, envp, dir, input, stdout, stderr, timeout);
    }

    private static void checkException(CharPump p, String msg) throws IOException {
        IOException ioe = p.getException();
        if (ioe != null) {
            throw new IOException("Exception processing " + msg);
        }
    }

    private static final class PumpReaderToWriter
    extends CharPump {
        private final Reader reader;
        private final Writer writer;

        public PumpReaderToWriter(Reader reader, Writer writer) {
            this.reader = reader;
            this.writer = writer;
        }

        @Override
        protected int sourceData(char[] buf) throws IOException {
            return this.reader.read(buf, 0, buf.length);
        }

        @Override
        protected void sinkData(char[] buf, int len) throws IOException {
            this.writer.write(buf, 0, len);
            this.writer.flush();
        }

        @Override
        protected void shutdownHook() throws IOException {
            this.writer.close();
        }
    }

    private static final class PumpReaderToNull
    extends CharPump {
        private final Reader is;

        public PumpReaderToNull(Reader is) {
            this.is = is;
        }

        @Override
        protected int sourceData(char[] buf) throws IOException {
            return this.is.read(buf);
        }

        @Override
        protected void sinkData(char[] buf, int len) {
        }
    }

    private static abstract class CharPump
    extends Thread {
        private IOException err = null;

        private CharPump() {
        }

        protected abstract int sourceData(char[] var1) throws IOException;

        protected abstract void sinkData(char[] var1, int var2) throws IOException;

        protected void shutdownHook() throws IOException {
        }

        @Override
        public void run() {
            try {
                int cnt;
                char[] buf = new char[256];
                do {
                    if ((cnt = this.sourceData(buf)) <= 0) continue;
                    this.sinkData(buf, cnt);
                } while (cnt >= 0);
                this.shutdownHook();
            }
            catch (IOException e) {
                this.err = e;
            }
        }

        public IOException getException() {
            return this.err;
        }
    }

    private static class TimeBomb
    extends Thread {
        private volatile boolean ticking = false;
        private volatile boolean fired = false;
        private final long time;
        private final Process victim;

        public TimeBomb(Process victim, long time) {
            this.time = time;
            this.victim = victim;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimeBomb timeBomb = this;
            synchronized (timeBomb) {
                try {
                    this.ticking = true;
                    this.wait(this.time);
                }
                catch (InterruptedException ex) {
                    System.err.println("Timebomb thread was interrupted -- this shouldn't happen");
                }
            }
            if (this.ticking) {
                this.fired = true;
                this.victim.destroy();
            }
        }

        public synchronized void defuse() {
            this.ticking = false;
            this.notifyAll();
        }

        public boolean fired() {
            return this.fired;
        }
    }
}

