/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class OverlayMap
extends AbstractMap {
    private Map parent;
    private Map overlay;

    public OverlayMap(Map parent, Map overlay) {
        this.parent = parent;
        this.overlay = overlay;
    }

    public OverlayMap(Map parent) {
        this.parent = parent;
        this.overlay = new HashMap();
    }

    public Map getParentMap() {
        return this.parent;
    }

    public Map getOverlayMap() {
        return this.overlay;
    }

    @Override
    public Object get(Object key) {
        Object value = this.overlay.get(key);
        if (value == null) {
            value = this.parent.get(key);
        }
        return value;
    }

    @Override
    public Set entrySet() {
        return new OEntrySet();
    }

    @Override
    public Set keySet() {
        return new OKeySet();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.overlay.containsKey(key) || this.parent.containsKey(key);
    }

    @Override
    public Object put(Object key, Object value) {
        Object old = this.get(key);
        this.overlay.put(key, value);
        return old;
    }

    private static class OMapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        private OMapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry mo = (Map.Entry)o;
            return (this.key == null ? mo.getKey() == null : this.key.equals(mo.getKey())) && (this.value == null ? mo.getValue() == null : this.value.equals(mo.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private class OEntrySet
    extends AbstractSet {
        OKeySet ks;

        private OEntrySet() {
            this.ks = new OKeySet();
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                Iterator ksi;
                {
                    this.ksi = OEntrySet.this.ks.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.ksi.hasNext();
                }

                public Object next() {
                    Object k = this.ksi.next();
                    Object v = OverlayMap.this.get(k);
                    return new OMapEntry(k, v);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.ks.size();
        }
    }

    private class OKeySet
    extends AbstractSet {
        private Set parentKeys;

        private OKeySet() {
            this.parentKeys = OverlayMap.this.parent.keySet();
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                Iterator oi;
                Iterator pi;
                Object peek;
                {
                    this.oi = OverlayMap.this.overlay.keySet().iterator();
                    this.pi = OKeySet.this.parentKeys.iterator();
                    this.peek = null;
                }

                @Override
                public boolean hasNext() {
                    if (this.peek == null) {
                        this.peek = this.nextObject();
                    }
                    return this.peek != null;
                }

                public Object next() {
                    if (this.peek == null) {
                        this.peek = this.nextObject();
                    }
                    if (this.peek == null) {
                        throw new NoSuchElementException();
                    }
                    Object o = this.peek;
                    this.peek = null;
                    return o;
                }

                private Object nextObject() {
                    if (this.oi.hasNext()) {
                        return this.oi.next();
                    }
                    Object po = null;
                    while (po == null && this.pi.hasNext()) {
                        po = this.pi.next();
                        if (!OverlayMap.this.overlay.containsKey(po)) continue;
                        po = null;
                    }
                    return po;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            int i = 0;
            Iterator keys = this.iterator();
            while (keys.hasNext()) {
                keys.next();
                ++i;
            }
            return i;
        }

        @Override
        public boolean contains(Object o) {
            return OverlayMap.this.overlay.containsKey(o) || this.parentKeys.contains(o);
        }
    }
}

