/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.biojava.stats.svm.SVMKernel;

public class SparseVector
implements Serializable {
    int size;
    int[] keys;
    double[] values;
    public static final SVMKernel kernel = new SparseVectorKernel();

    public SparseVector() {
        this(1);
    }

    public SparseVector(int capacity) {
        this.keys = new int[capacity];
        this.values = new double[capacity];
        Arrays.fill(this.keys, 0, capacity, Integer.MAX_VALUE);
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public void put(int dim, double value) {
        int indx = Arrays.binarySearch(this.keys, dim);
        if (indx >= 0) {
            this.values[indx] = value;
        } else {
            indx = -(indx + 1);
            if (this.size + 1 >= this.keys.length) {
                int[] nKeys = new int[this.keys.length * 2];
                Arrays.fill(nKeys, this.size, nKeys.length, Integer.MAX_VALUE);
                System.arraycopy(this.keys, 0, nKeys, 0, indx);
                System.arraycopy(this.keys, indx, nKeys, indx + 1, this.size - indx);
                this.keys = nKeys;
                double[] nValues = new double[this.values.length * 2];
                Arrays.fill(nValues, this.size, nValues.length, Double.NaN);
                System.arraycopy(this.values, 0, nValues, 0, indx);
                System.arraycopy(this.values, indx, nValues, indx + 1, this.size - indx);
                this.values = nValues;
            } else {
                try {
                    System.arraycopy(this.keys, indx, this.keys, indx + 1, this.size - indx);
                    System.arraycopy(this.values, indx, this.values, indx + 1, this.size - indx);
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                    System.out.println("dim         = " + dim);
                    System.out.println("value       = " + value);
                    System.out.println("keys.length = " + this.keys.length);
                    System.out.println("size        = " + this.size);
                    System.out.println("indx        = " + indx);
                    System.out.println("indx+1      = " + (indx + 1));
                    System.out.println("size-indx   = " + (this.size - indx));
                    System.out.println("size+1      = " + (this.size + 1));
                    throw ae;
                }
            }
            this.keys[indx] = dim;
            this.values[indx] = value;
            ++this.size;
        }
    }

    public double get(int dim) {
        int pos = Arrays.binarySearch(this.keys, dim);
        if (pos >= 0) {
            return this.values[pos];
        }
        return 0.0;
    }

    public int getDimAtIndex(int indx) {
        if (indx >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Attempted to read item " + indx + " of an array with " + this.size + "elements");
        }
        return this.keys[indx];
    }

    public double getValueAtIndex(int indx) {
        if (indx >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Attempted to read item " + indx + " of an array with " + this.size + "elements");
        }
        return this.values[indx];
    }

    public int maxIndex() {
        return this.keys[this.size - 1];
    }

    public static SparseVector normalLengthVector(SparseVector v, double length) {
        int i;
        SparseVector n = new SparseVector(v.size);
        double oldLength = 0.0;
        for (i = 0; i < v.size; ++i) {
            oldLength += v.values[i] * v.values[i];
        }
        oldLength = Math.sqrt(oldLength);
        for (i = 0; i < v.size; ++i) {
            n.put(v.keys[i], v.values[i] * length / oldLength);
        }
        return n;
    }

    public static class NormalizingKernel
    implements SVMKernel,
    Serializable {
        private SparseVector s;

        public SparseVector getNormalizingVector() {
            return this.s;
        }

        public void setNormalizingVector(SparseVector nv) {
            this.s = nv;
        }

        @Override
        public double evaluate(Object o1, Object o2) {
            SparseVector a = (SparseVector)o1;
            SparseVector b = (SparseVector)o2;
            int ai = 0;
            int bi = 0;
            int si = 0;
            double total = 0.0;
            while (ai < a.size && bi < b.size && si < this.s.size) {
                if (a.keys[ai] < b.keys[bi] || a.keys[ai] < this.s.keys[si]) {
                    ++ai;
                    continue;
                }
                if (b.keys[bi] < a.keys[ai] || b.keys[bi] < this.s.keys[si]) {
                    ++bi;
                    continue;
                }
                if (this.s.keys[si] < a.keys[ai] || this.s.keys[si] < b.keys[bi]) {
                    ++si;
                    continue;
                }
                if (a.keys[ai] == this.s.keys[si] && b.keys[bi] == this.s.keys[si]) {
                    total += a.values[ai++] * b.values[bi++] * (double)a.keys[ai - 1];
                    continue;
                }
                System.out.println("ai = " + ai);
                System.out.println("bi = " + bi);
                System.out.println("si = " + si);
                System.exit(1);
            }
            return total;
        }

        public NormalizingKernel(SparseVector s) {
            this.s = s;
        }

        public NormalizingKernel(List vectors) {
            this.s = new SparseVector();
            for (SparseVector v : vectors) {
                for (int j = 0; j < v.size(); ++j) {
                    this.s.put(v.keys[j], this.s.get(v.keys[j]) + v.values[j]);
                }
            }
            for (int j = 0; j < this.s.size(); ++j) {
                this.s.values[j] = (double)vectors.size() / this.s.values[j];
                int n = j;
                this.s.values[n] = this.s.values[n] * this.s.values[j];
            }
        }

        public String toString() {
            return "SparseVector.NormalizingKernel K(x, y | s) = sum_i ( x_i * y_i * s_i ).";
        }
    }

    private static class SparseVectorKernel
    implements SVMKernel,
    Serializable {
        private SparseVectorKernel() {
        }

        @Override
        public double evaluate(Object o1, Object o2) {
            SparseVector a = (SparseVector)o1;
            SparseVector b = (SparseVector)o2;
            int ai = 0;
            int bi = 0;
            double total = 0.0;
            while (ai < a.size && bi < b.size) {
                if (a.keys[ai] > b.keys[bi]) {
                    ++bi;
                    continue;
                }
                if (a.keys[ai] < b.keys[bi]) {
                    ++ai;
                    continue;
                }
                total += a.values[ai++] * b.values[bi++];
            }
            return total;
        }

        public String toString() {
            return "SparseVector kernel K(x, y) = sum_i ( x_i * y_i ).";
        }
    }
}

