/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.stats.svm.AbstractSVMClassifierModel;
import org.biojava.stats.svm.ItemValue;
import org.biojava.stats.svm.SVMKernel;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.stats.svm.SimpleItemValue;

public class SimpleSVMClassifierModel
extends AbstractSVMClassifierModel {
    private SVMKernel kernel;
    private double threshold;
    private Set itemAlphaSet;
    private Map itemToItemAlpha;

    public SimpleSVMClassifierModel(SVMKernel kernel) {
        this.kernel = kernel;
        this.itemAlphaSet = new HashSet();
        this.itemToItemAlpha = new HashMap();
    }

    public SimpleSVMClassifierModel(SVMKernel kernel, Collection items) {
        this(kernel);
        Iterator i = items.iterator();
        while (i.hasNext()) {
            this.addItem(i.next());
        }
    }

    public SimpleSVMClassifierModel(SVMKernel kernel, SVMTarget target) {
        this(kernel, target.items());
    }

    @Override
    public SVMKernel getKernel() {
        return this.kernel;
    }

    @Override
    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public double getThreshold() {
        return this.threshold;
    }

    @Override
    public Set items() {
        return this.itemToItemAlpha.keySet();
    }

    @Override
    public Set itemAlphas() {
        return this.itemAlphaSet;
    }

    @Override
    public double getAlpha(Object item) {
        return ((ItemValue)this.itemToItemAlpha.get(item)).getValue();
    }

    @Override
    public void setAlpha(Object item, double alpha) {
        ItemValue iv = (ItemValue)this.itemToItemAlpha.get(item);
        iv.setValue(alpha);
    }

    @Override
    public void addItem(Object item) {
        SimpleItemValue iv = new SimpleItemValue(item, 0.0);
        this.itemToItemAlpha.put(item, iv);
        this.itemAlphaSet.add(iv);
    }

    @Override
    public void addItemAlpha(Object item, double alpha) {
        SimpleItemValue iv = new SimpleItemValue(item, alpha);
        this.itemToItemAlpha.put(item, iv);
        this.itemAlphaSet.add(iv);
    }

    @Override
    public void removeItem(Object item) {
        this.itemToItemAlpha.remove(item);
        this.itemAlphaSet.remove(item);
    }

    @Override
    public void clear() {
        this.itemAlphaSet.clear();
        this.itemToItemAlpha.clear();
    }
}

