/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import org.biojava.bio.Annotation;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class SubList
extends AbstractSymbolList
implements Serializable {
    private SymbolList parent;
    private int start;
    private int end;
    private transient AbstractSymbolList.EditTranslater editTranslater = null;
    private transient ChangeForwarder annotationForwarder = null;

    public SubList(SymbolList parent, int start, int end) {
        this.parent = parent;
        this.start = start;
        this.end = end;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.parent.getAlphabet();
    }

    @Override
    public int length() {
        return this.end - this.start + 1;
    }

    @Override
    public Symbol symbolAt(int pos) {
        if (pos < 1 || pos > this.length()) {
            throw new IndexOutOfBoundsException("Symbol index out of bounds " + this.length() + ":" + pos);
        }
        return this.parent.symbolAt(pos + this.start - 1);
    }

    @Override
    public SymbolList subList(int sstart, int send) {
        if (sstart < 1 || send > this.length()) {
            throw new IndexOutOfBoundsException("Sublist index out of bounds " + this.length() + ":" + sstart + "," + send);
        }
        if (send < sstart) {
            throw new IndexOutOfBoundsException("Requested end must not be lower than start: start=" + sstart + ", end=" + send);
        }
        return new SubList(this.parent, sstart + this.start - 1, send + this.start - 1);
    }

    @Override
    public void edit(Edit edit) throws IllegalAlphabetException, ChangeVetoException {
        this.parent.edit(new Edit(edit.pos + this.start - 1, edit.length, edit.replacement));
    }

    @Override
    protected ChangeSupport getChangeSupport(ChangeType changeType) {
        ChangeSupport cs = super.getChangeSupport(changeType);
        if ((SymbolList.EDIT.isMatchingType(changeType) || changeType.isMatchingType(SymbolList.EDIT)) && this.editTranslater == null) {
            this.editTranslater = new AbstractSymbolList.EditTranslater(this, cs, this.start, this.end);
            this.parent.addChangeListener(this.editTranslater, SymbolList.EDIT);
        }
        if ((changeType == null || changeType == Annotation.PROPERTY) && this.annotationForwarder == null) {
            this.annotationForwarder = new ChangeForwarder.Retyper(this, cs, Annotation.PROPERTY);
            this.parent.addChangeListener(this.annotationForwarder, Annotation.PROPERTY);
        }
        return cs;
    }

    @Override
    public String toString() {
        return super.toString() + " start: " + this.start + " end: " + this.end;
    }
}

